/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.gson.Gson;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.autoconfigure.web.HttpEncodingProperties;
import org.springframework.boot.autoconfigure.web.HttpMapperProperties;
import org.springframework.boot.autoconfigure.web.HttpMessageConverters;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.GsonHttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;

@Configuration
@ConditionalOnClass(value={HttpMessageConverter.class})
@AutoConfigureAfter(value={JacksonAutoConfiguration.class})
public class HttpMessageConvertersAutoConfiguration {
    @Autowired(required=false)
    private final List<HttpMessageConverter<?>> converters = Collections.emptyList();

    @Bean
    @ConditionalOnMissingBean
    public HttpMessageConverters messageConverters() {
        return new HttpMessageConverters(this.converters);
    }

    @Configuration
    @ConditionalOnClass(value={StringHttpMessageConverter.class})
    @EnableConfigurationProperties(value={HttpEncodingProperties.class})
    protected static class StringHttpMessageConverterConfiguration {
        @Autowired
        private HttpEncodingProperties encodingProperties;

        protected StringHttpMessageConverterConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public StringHttpMessageConverter stringHttpMessageConverter() {
            return new StringHttpMessageConverter(this.encodingProperties.getCharset());
        }
    }

    @Configuration
    @ConditionalOnClass(value={Gson.class})
    @ConditionalOnMissingClass(name={"com.fasterxml.jackson.core.JsonGenerator"})
    @ConditionalOnBean(value={Gson.class})
    protected static class GsonHttpMessageConverterConfiguration {
        protected GsonHttpMessageConverterConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public GsonHttpMessageConverter gsonHttpMessageConverter(Gson gson) {
            GsonHttpMessageConverter converter = new GsonHttpMessageConverter();
            converter.setGson(gson);
            return converter;
        }
    }

    @Configuration
    @ConditionalOnClass(value={XmlMapper.class})
    @ConditionalOnBean(value={Jackson2ObjectMapperBuilder.class})
    @EnableConfigurationProperties(value={HttpMapperProperties.class})
    protected static class MappingJackson2XmlHttpMessageConverterConfiguration {
        @Autowired
        private HttpMapperProperties properties = new HttpMapperProperties();

        protected MappingJackson2XmlHttpMessageConverterConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public MappingJackson2XmlHttpMessageConverter mappingJackson2XmlHttpMessageConverter(Jackson2ObjectMapperBuilder builder) {
            MappingJackson2XmlHttpMessageConverter converter = new MappingJackson2XmlHttpMessageConverter();
            converter.setObjectMapper(builder.createXmlMapper(true).build());
            if (this.properties.isJsonPrettyPrint() != null) {
                converter.setPrettyPrint(this.properties.isJsonPrettyPrint().booleanValue());
            }
            return converter;
        }
    }

    @Configuration
    @ConditionalOnClass(value={ObjectMapper.class})
    @ConditionalOnBean(value={ObjectMapper.class})
    @EnableConfigurationProperties(value={HttpMapperProperties.class})
    protected static class MappingJackson2HttpMessageConverterConfiguration {
        @Autowired
        private HttpMapperProperties properties = new HttpMapperProperties();

        protected MappingJackson2HttpMessageConverterConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter(ObjectMapper objectMapper) {
            MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
            converter.setObjectMapper(objectMapper);
            if (this.properties.isJsonPrettyPrint() != null) {
                converter.setPrettyPrint(this.properties.isJsonPrettyPrint().booleanValue());
            }
            return converter;
        }
    }
}

