/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.influx;

import okhttp3.OkHttpClient;
import org.influxdb.InfluxDB;
import org.influxdb.impl.InfluxDBImpl;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.influx.InfluxDbOkHttpClientBuilderProvider;
import org.springframework.boot.autoconfigure.influx.InfluxDbProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={InfluxDB.class})
@EnableConfigurationProperties(value={InfluxDbProperties.class})
public class InfluxDbAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.influx.url"})
    public InfluxDB influxDb(InfluxDbProperties properties, ObjectProvider<InfluxDbOkHttpClientBuilderProvider> builder) {
        return new InfluxDBImpl(properties.getUrl(), properties.getUser(), properties.getPassword(), InfluxDbAutoConfiguration.determineBuilder((InfluxDbOkHttpClientBuilderProvider)builder.getIfAvailable()));
    }

    private static OkHttpClient.Builder determineBuilder(InfluxDbOkHttpClientBuilderProvider builder) {
        if (builder != null) {
            return (OkHttpClient.Builder)builder.get();
        }
        return new OkHttpClient.Builder();
    }
}

