/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.kafka;

import java.time.Duration;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.listener.AfterRollbackProcessor;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.ErrorHandler;
import org.springframework.kafka.support.converter.MessageConverter;
import org.springframework.kafka.transaction.KafkaAwareTransactionManager;

public class ConcurrentKafkaListenerContainerFactoryConfigurer {
    private KafkaProperties properties;
    private MessageConverter messageConverter;
    private KafkaTemplate<Object, Object> replyTemplate;
    private KafkaAwareTransactionManager<Object, Object> transactionManager;
    private ErrorHandler errorHandler;
    private AfterRollbackProcessor<Object, Object> afterRollbackProcessor;

    void setKafkaProperties(KafkaProperties properties) {
        this.properties = properties;
    }

    void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    void setReplyTemplate(KafkaTemplate<Object, Object> replyTemplate) {
        this.replyTemplate = replyTemplate;
    }

    void setTransactionManager(KafkaAwareTransactionManager<Object, Object> transactionManager) {
        this.transactionManager = transactionManager;
    }

    void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    void setAfterRollbackProcessor(AfterRollbackProcessor<Object, Object> afterRollbackProcessor) {
        this.afterRollbackProcessor = afterRollbackProcessor;
    }

    public void configure(ConcurrentKafkaListenerContainerFactory<Object, Object> listenerFactory, ConsumerFactory<Object, Object> consumerFactory) {
        listenerFactory.setConsumerFactory(consumerFactory);
        this.configureListenerFactory(listenerFactory);
        this.configureContainer(listenerFactory.getContainerProperties());
    }

    private void configureListenerFactory(ConcurrentKafkaListenerContainerFactory<Object, Object> factory) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        KafkaProperties.Listener properties = this.properties.getListener();
        map.from(properties::getConcurrency).to(arg_0 -> factory.setConcurrency(arg_0));
        map.from((Object)this.messageConverter).to(arg_0 -> factory.setMessageConverter(arg_0));
        map.from(this.replyTemplate).to(arg_0 -> factory.setReplyTemplate(arg_0));
        map.from(properties::getType).whenEqualTo((Object)KafkaProperties.Listener.Type.BATCH).toCall(() -> factory.setBatchListener(Boolean.valueOf(true)));
        map.from((Object)this.errorHandler).to(arg_0 -> factory.setErrorHandler(arg_0));
        map.from(this.afterRollbackProcessor).to(arg_0 -> factory.setAfterRollbackProcessor(arg_0));
    }

    private void configureContainer(ContainerProperties container) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        KafkaProperties.Listener properties = this.properties.getListener();
        map.from(properties::getAckMode).to(arg_0 -> ((ContainerProperties)container).setAckMode(arg_0));
        map.from(properties::getClientId).to(arg_0 -> ((ContainerProperties)container).setClientId(arg_0));
        map.from(properties::getAckCount).to(arg_0 -> ((ContainerProperties)container).setAckCount(arg_0));
        map.from(properties::getAckTime).as(Duration::toMillis).to(arg_0 -> ((ContainerProperties)container).setAckTime(arg_0));
        map.from(properties::getPollTimeout).as(Duration::toMillis).to(arg_0 -> ((ContainerProperties)container).setPollTimeout(arg_0));
        map.from(properties::getNoPollThreshold).to(arg_0 -> ((ContainerProperties)container).setNoPollThreshold(arg_0));
        map.from(properties::getIdleEventInterval).as(Duration::toMillis).to(arg_0 -> ((ContainerProperties)container).setIdleEventInterval(arg_0));
        map.from(properties::getMonitorInterval).as(Duration::getSeconds).as(Number::intValue).to(arg_0 -> ((ContainerProperties)container).setMonitorInterval(arg_0));
        map.from(properties::getLogContainerConfig).to(arg_0 -> ((ContainerProperties)container).setLogContainerConfig(arg_0));
        map.from(this.transactionManager).to(arg_0 -> ((ContainerProperties)container).setTransactionManager(arg_0));
    }
}

