/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mustache;

import com.samskivert.mustache.Mustache;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.mustache.MustacheProperties;
import org.springframework.boot.web.reactive.result.view.MustacheViewResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
class MustacheReactiveWebConfiguration {
    MustacheReactiveWebConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    public MustacheViewResolver mustacheViewResolver(Mustache.Compiler mustacheCompiler, MustacheProperties mustache) {
        MustacheViewResolver resolver = new MustacheViewResolver(mustacheCompiler);
        resolver.setPrefix(mustache.getPrefix());
        resolver.setSuffix(mustache.getSuffix());
        resolver.setViewNames(mustache.getViewNames());
        resolver.setRequestContextAttribute(mustache.getRequestContextAttribute());
        resolver.setCharset(mustache.getCharsetName());
        resolver.setOrder(0x7FFFFFF5);
        return resolver;
    }
}

