/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.neo4j;

import com.github.benmanes.caffeine.cache.Caffeine;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnNotWebApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.data.neo4j.bookmark.BeanFactoryBookmarkOperationAdvisor;
import org.springframework.data.neo4j.bookmark.BookmarkInterceptor;
import org.springframework.data.neo4j.bookmark.BookmarkManager;
import org.springframework.data.neo4j.bookmark.CaffeineBookmarkManager;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Caffeine.class, CaffeineCacheManager.class})
@ConditionalOnMissingBean(value={BookmarkManager.class})
@ConditionalOnBean(value={BeanFactoryBookmarkOperationAdvisor.class, BookmarkInterceptor.class})
class Neo4jBookmarkManagementConfiguration {
    private static final String BOOKMARK_MANAGER_BEAN_NAME = "bookmarkManager";

    Neo4jBookmarkManagementConfiguration() {
    }

    @Bean(value={"bookmarkManager"})
    @ConditionalOnWebApplication
    @Scope(value="request", proxyMode=ScopedProxyMode.INTERFACES)
    public BookmarkManager requestScopedBookmarkManager() {
        return new CaffeineBookmarkManager();
    }

    @Bean(value={"bookmarkManager"})
    @ConditionalOnNotWebApplication
    public BookmarkManager singletonScopedBookmarkManager() {
        return new CaffeineBookmarkManager();
    }
}

