/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.rsocket;

import io.rsocket.RSocketFactory;
import io.rsocket.SocketAcceptor;
import io.rsocket.transport.netty.server.TcpServerTransport;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.rsocket.RSocketNettyServerCustomizer;
import org.springframework.boot.autoconfigure.rsocket.RSocketProperties;
import org.springframework.boot.autoconfigure.rsocket.RSocketStrategiesAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.rsocket.netty.NettyRSocketServerFactory;
import org.springframework.boot.rsocket.server.RSocketServerBootstrap;
import org.springframework.boot.rsocket.server.RSocketServerFactory;
import org.springframework.boot.rsocket.server.ServerRSocketFactoryCustomizer;
import org.springframework.boot.web.embedded.netty.NettyReactiveWebServerFactory;
import org.springframework.boot.web.embedded.netty.NettyServerCustomizer;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.http.client.reactive.ReactorResourceFactory;
import org.springframework.messaging.rsocket.MessageHandlerAcceptor;
import org.springframework.messaging.rsocket.RSocketStrategies;
import reactor.netty.http.server.HttpServer;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={RSocketFactory.class, RSocketStrategies.class, HttpServer.class, TcpServerTransport.class})
@ConditionalOnBean(value={MessageHandlerAcceptor.class})
@AutoConfigureAfter(value={RSocketStrategiesAutoConfiguration.class})
@EnableConfigurationProperties(value={RSocketProperties.class})
public class RSocketServerAutoConfiguration {

    static class OnRSocketWebServerCondition
    extends AllNestedConditions {
        OnRSocketWebServerCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="spring.rsocket.server", name={"transport"}, havingValue="websocket")
        static class HasWebsocketTransportConfigured {
            HasWebsocketTransportConfigured() {
            }
        }

        @ConditionalOnProperty(prefix="spring.rsocket.server", name={"mapping-path"})
        static class HasMappingPathConfigured {
            HasMappingPathConfigured() {
            }
        }

        @ConditionalOnProperty(prefix="spring.rsocket.server", name={"port"}, matchIfMissing=true)
        static class HasNoPortConfigured {
            HasNoPortConfigured() {
            }
        }

        @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
        static class IsReactiveWebApplication {
            IsReactiveWebApplication() {
            }
        }
    }

    @ConditionalOnProperty(prefix="spring.rsocket.server", name={"port"})
    @Configuration(proxyBeanMethods=false)
    static class EmbeddedServerAutoConfiguration {
        EmbeddedServerAutoConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public ReactorResourceFactory reactorServerResourceFactory() {
            return new ReactorResourceFactory();
        }

        @Bean
        @ConditionalOnMissingBean
        public RSocketServerFactory rSocketServerFactory(RSocketProperties properties, ReactorResourceFactory resourceFactory, ObjectProvider<ServerRSocketFactoryCustomizer> customizers) {
            NettyRSocketServerFactory factory = new NettyRSocketServerFactory();
            factory.setResourceFactory(resourceFactory);
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from((Object)properties.getServer().getAddress()).to(arg_0 -> ((NettyRSocketServerFactory)factory).setAddress(arg_0));
            map.from((Object)properties.getServer().getPort()).to(arg_0 -> ((NettyRSocketServerFactory)factory).setPort(arg_0));
            factory.setServerCustomizers((Collection)customizers.orderedStream().collect(Collectors.toList()));
            return factory;
        }

        @Bean
        public RSocketServerBootstrap rSocketServerBootstrap(RSocketServerFactory rSocketServerFactory, SocketAcceptor socketAcceptor) {
            return new RSocketServerBootstrap(rSocketServerFactory, socketAcceptor);
        }
    }

    @Conditional(value={OnRSocketWebServerCondition.class})
    @Configuration(proxyBeanMethods=false)
    static class WebFluxServerAutoConfiguration {
        WebFluxServerAutoConfiguration() {
        }

        @Bean
        public WebServerFactoryCustomizer<NettyReactiveWebServerFactory> rSocketWebsocketCustomizer(RSocketProperties properties, MessageHandlerAcceptor messageHandlerAcceptor) {
            RSocketNettyServerCustomizer customizer = new RSocketNettyServerCustomizer(properties.getServer().getMappingPath(), messageHandlerAcceptor);
            return factory -> factory.addServerCustomizers(new NettyServerCustomizer[]{customizer});
        }
    }
}

