/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.rsocket;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.rsocket.RSocketFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.rsocket.messaging.RSocketStrategiesCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.annotation.Order;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.MediaType;
import org.springframework.http.codec.cbor.Jackson2CborDecoder;
import org.springframework.http.codec.cbor.Jackson2CborEncoder;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.messaging.rsocket.RSocketStrategies;
import org.springframework.util.MimeType;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={RSocketFactory.class, RSocketStrategies.class, PooledByteBufAllocator.class})
@AutoConfigureAfter(value={JacksonAutoConfiguration.class})
public class RSocketStrategiesAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public RSocketStrategies rSocketStrategies(ObjectProvider<RSocketStrategiesCustomizer> customizers) {
        RSocketStrategies.Builder builder = RSocketStrategies.builder();
        builder.reactiveAdapterStrategy(ReactiveAdapterRegistry.getSharedInstance());
        customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
        builder.dataBufferFactory((DataBufferFactory)new NettyDataBufferFactory((ByteBufAllocator)PooledByteBufAllocator.DEFAULT));
        return builder.build();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ObjectMapper.class})
    protected static class JacksonJsonStrategyConfiguration {
        protected JacksonJsonStrategyConfiguration() {
        }

        @Bean
        @Order(value=1)
        @ConditionalOnBean(value={ObjectMapper.class})
        public RSocketStrategiesCustomizer jacksonJsonStrategyCustomizer(ObjectMapper objectMapper) {
            return strategy -> {
                MediaType[] supportedTypes = new MediaType[]{MediaType.APPLICATION_JSON, new MediaType("application", "*+json")};
                strategy.decoder(new Decoder[]{new Jackson2JsonDecoder(objectMapper, (MimeType[])supportedTypes)});
                strategy.encoder(new Encoder[]{new Jackson2JsonEncoder(objectMapper, (MimeType[])supportedTypes)});
            };
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ObjectMapper.class, CBORFactory.class})
    protected static class JacksonCborStrategyConfiguration {
        protected JacksonCborStrategyConfiguration() {
        }

        @Bean
        @Order(value=0)
        @ConditionalOnBean(value={Jackson2ObjectMapperBuilder.class})
        public RSocketStrategiesCustomizer jacksonCborStrategyCustomizer(Jackson2ObjectMapperBuilder builder) {
            return strategy -> {
                ObjectMapper objectMapper = builder.factory((JsonFactory)new CBORFactory()).build();
                MediaType[] supportedTypes = new MediaType[]{new MediaType("application", "cbor")};
                strategy.decoder(new Decoder[]{new Jackson2CborDecoder(objectMapper, (MimeType[])supportedTypes)});
                strategy.encoder(new Encoder[]{new Jackson2CborEncoder(objectMapper, (MimeType[])supportedTypes)});
            };
        }
    }
}

