/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceInitializer;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;

public class DataSourceInitialization
implements InitializingBean,
ResourceLoaderAware {
    private final DataSource dataSource;
    private final DataSourceProperties properies;
    private volatile ResourceLoader resourceLoader;

    public DataSourceInitialization(DataSource dataSource, DataSourceProperties properies) {
        this.dataSource = dataSource;
        this.properies = properies;
    }

    public void afterPropertiesSet() throws Exception {
        new DataSourceInitializer(this.dataSource, this.properies, this.resourceLoader).initializeDataSource();
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

