/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.session;

import java.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.session.RedisSessionProperties;
import org.springframework.boot.autoconfigure.session.SessionProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.session.SessionRepository;
import org.springframework.session.data.redis.RedisIndexedSessionRepository;
import org.springframework.session.data.redis.config.ConfigureNotifyKeyspaceEventsAction;
import org.springframework.session.data.redis.config.ConfigureRedisAction;
import org.springframework.session.data.redis.config.annotation.web.http.RedisIndexedHttpSessionConfiguration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={RedisTemplate.class, RedisIndexedSessionRepository.class})
@ConditionalOnMissingBean(value={SessionRepository.class})
@ConditionalOnBean(value={RedisConnectionFactory.class})
@EnableConfigurationProperties(value={RedisSessionProperties.class})
class RedisSessionConfiguration {
    RedisSessionConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    ConfigureRedisAction configureRedisAction(RedisSessionProperties redisSessionProperties) {
        return switch (redisSessionProperties.getConfigureAction()) {
            default -> throw new IncompatibleClassChangeError();
            case RedisSessionProperties.ConfigureAction.NOTIFY_KEYSPACE_EVENTS -> new ConfigureNotifyKeyspaceEventsAction();
            case RedisSessionProperties.ConfigureAction.NONE -> ConfigureRedisAction.NO_OP;
        };
    }

    @Configuration(proxyBeanMethods=false)
    public static class SpringBootRedisHttpSessionConfiguration
    extends RedisIndexedHttpSessionConfiguration {
        @Autowired
        public void customize(SessionProperties sessionProperties, RedisSessionProperties redisSessionProperties, ServerProperties serverProperties) {
            Duration timeout = sessionProperties.determineTimeout(() -> serverProperties.getServlet().getSession().getTimeout());
            if (timeout != null) {
                this.setMaxInactiveIntervalInSeconds((int)timeout.getSeconds());
            }
            this.setRedisNamespace(redisSessionProperties.getNamespace());
            this.setFlushMode(redisSessionProperties.getFlushMode());
            this.setSaveMode(redisSessionProperties.getSaveMode());
            this.setCleanupCron(redisSessionProperties.getCleanupCron());
        }
    }
}

