/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.session;

import com.hazelcast.core.HazelcastInstance;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.session.HazelcastSessionProperties;
import org.springframework.boot.autoconfigure.session.SessionProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.session.SessionRepository;
import org.springframework.session.config.SessionRepositoryCustomizer;
import org.springframework.session.hazelcast.HazelcastIndexedSessionRepository;
import org.springframework.session.hazelcast.config.annotation.web.http.HazelcastHttpSessionConfiguration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={HazelcastIndexedSessionRepository.class})
@ConditionalOnMissingBean(value={SessionRepository.class})
@ConditionalOnBean(value={HazelcastInstance.class})
@EnableConfigurationProperties(value={HazelcastSessionProperties.class})
@Import(value={HazelcastHttpSessionConfiguration.class})
class HazelcastSessionConfiguration {
    HazelcastSessionConfiguration() {
    }

    @Bean
    SessionRepositoryCustomizer<HazelcastIndexedSessionRepository> springBootSessionRepositoryCustomizer(SessionProperties sessionProperties, HazelcastSessionProperties hazelcastSessionProperties, ServerProperties serverProperties) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        return sessionRepository -> {
            map.from((Object)sessionProperties.determineTimeout(() -> serverProperties.getServlet().getSession().getTimeout())).to(arg_0 -> ((HazelcastIndexedSessionRepository)sessionRepository).setDefaultMaxInactiveInterval(arg_0));
            map.from(hazelcastSessionProperties::getMapName).to(arg_0 -> ((HazelcastIndexedSessionRepository)sessionRepository).setSessionMapName(arg_0));
            map.from(hazelcastSessionProperties::getFlushMode).to(arg_0 -> ((HazelcastIndexedSessionRepository)sessionRepository).setFlushMode(arg_0));
            map.from(hazelcastSessionProperties::getSaveMode).to(arg_0 -> ((HazelcastIndexedSessionRepository)sessionRepository).setSaveMode(arg_0));
        };
    }
}

