/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import org.springframework.boot.cli.Command;
import org.springframework.boot.cli.CommandFactory;
import org.springframework.boot.cli.Log;
import org.springframework.boot.cli.NoSuchCommandException;
import org.springframework.boot.cli.SpringCliException;

public class SpringCli {
    public static final String CLI_APP = "spring";
    private static final Set<SpringCliException.Option> NO_EXCEPTION_OPTIONS = EnumSet.noneOf(SpringCliException.Option.class);
    private List<Command> commands;

    public SpringCli() {
        this.setCommands(ServiceLoader.load(CommandFactory.class, this.getClass().getClassLoader()));
    }

    private void setCommands(Iterable<CommandFactory> iterable) {
        this.commands = new ArrayList<Command>();
        for (CommandFactory factory : iterable) {
            for (Command command : factory.getCommands()) {
                this.commands.add(command);
            }
        }
        this.commands.add(0, new HelpCommand());
    }

    public void setCommands(List<? extends Command> commands) {
        this.commands = new ArrayList<Command>(commands);
        this.commands.add(0, new HelpCommand());
    }

    public int runAndHandleErrors(String ... args) {
        String[] argsWithoutDebugFlags = this.removeDebugFlags(args);
        boolean debug = argsWithoutDebugFlags.length != args.length;
        try {
            this.run(argsWithoutDebugFlags);
            return 0;
        }
        catch (NoArgumentsException ex) {
            this.showUsage();
            return 1;
        }
        catch (Exception ex) {
            return this.handleError(debug, ex);
        }
    }

    private int handleError(boolean debug, Exception ex) {
        Set<SpringCliException.Option> options = NO_EXCEPTION_OPTIONS;
        if (ex instanceof SpringCliException) {
            options = ((SpringCliException)ex).getOptions();
        }
        if (!(ex instanceof NoHelpCommandArgumentsException)) {
            this.errorMessage(ex.getMessage());
        }
        if (options.contains((Object)SpringCliException.Option.SHOW_USAGE)) {
            this.showUsage();
        }
        if (debug || options.contains((Object)SpringCliException.Option.STACK_TRACE)) {
            this.printStackTrace(ex);
        }
        return 1;
    }

    protected void run(String ... args) throws Exception {
        if (args.length == 0) {
            throw new NoArgumentsException();
        }
        String commandName = args[0];
        String[] commandArguments = Arrays.copyOfRange(args, 1, args.length);
        this.find(commandName).run(commandArguments);
    }

    private Command find(String name) {
        for (Command candidate : this.commands) {
            if (!candidate.getName().equals(name)) continue;
            return candidate;
        }
        throw new NoSuchCommandException(name);
    }

    protected void showUsage() {
        Log.info("usage: spring ");
        Log.info("");
        Log.info("       <command> [<args>]");
        Log.info("");
        Log.info("Available commands are:");
        for (Command command : this.commands) {
            String usageHelp = command.getUsageHelp();
            String description = command.getDescription();
            Log.info(String.format("\n  %1$s %2$-15s\n    %3$s", command.getName(), usageHelp == null ? "" : usageHelp, description == null ? "" : description));
        }
        Log.info("");
        Log.info("See 'spring help <command>' for more information on a specific command.");
    }

    protected void errorMessage(String message) {
        Log.error(message == null ? "Unexpected error" : message);
    }

    protected void printStackTrace(Exception ex) {
        Log.error("");
        Log.error(ex);
        Log.error("");
    }

    private String[] removeDebugFlags(String[] args) {
        ArrayList<String> rtn = new ArrayList<String>(args.length);
        for (String arg : args) {
            if ("-d".equals(arg) || "--debug".equals(arg)) continue;
            rtn.add(arg);
        }
        return rtn.toArray(new String[rtn.size()]);
    }

    public static void main(String ... args) {
        int exitCode = new SpringCli().runAndHandleErrors(args);
        if (exitCode != 0) {
            System.exit(exitCode);
        }
    }

    static class NoArgumentsException
    extends SpringCliException {
        private static final long serialVersionUID = 1L;

        NoArgumentsException() {
            super(new SpringCliException.Option[0]);
        }
    }

    static class NoHelpCommandArgumentsException
    extends SpringCliException {
        private static final long serialVersionUID = 1L;

        public NoHelpCommandArgumentsException() {
            super(SpringCliException.Option.SHOW_USAGE);
        }
    }

    private class HelpCommand
    implements Command {
        private HelpCommand() {
        }

        @Override
        public void run(String ... args) throws Exception {
            if (args.length == 0) {
                throw new NoHelpCommandArgumentsException();
            }
            String commandName = args[0];
            for (Command command : SpringCli.this.commands) {
                if (!command.getName().equals(commandName)) continue;
                Log.info("spring " + command.getName() + " - " + command.getDescription());
                Log.info("");
                if (command.getUsageHelp() != null) {
                    Log.info("usage: spring " + command.getName() + " " + command.getUsageHelp());
                    Log.info("");
                }
                if (command.getHelp() != null) {
                    Log.info(command.getHelp());
                }
                return;
            }
            throw new NoSuchCommandException(commandName);
        }

        @Override
        public String getName() {
            return "help";
        }

        @Override
        public String getDescription() {
            return "Get help on commands";
        }

        @Override
        public String getUsageHelp() {
            return "command";
        }

        @Override
        public String getHelp() {
            return null;
        }
    }
}

