/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class SpringCliException
extends RuntimeException {
    private static final long serialVersionUID = 0L;
    private final EnumSet<Option> options;

    public SpringCliException(Option ... options) {
        this.options = this.asEnumSet(options);
    }

    public SpringCliException(String message, Option ... options) {
        super(message);
        this.options = this.asEnumSet(options);
    }

    public SpringCliException(String message, Throwable cause, Option ... options) {
        super(message, cause);
        this.options = this.asEnumSet(options);
    }

    private EnumSet<Option> asEnumSet(Option[] options) {
        if (options == null || options.length == 0) {
            return EnumSet.noneOf(Option.class);
        }
        return EnumSet.copyOf(Arrays.asList(options));
    }

    public Set<Option> getOptions() {
        return Collections.unmodifiableSet(this.options);
    }

    public static enum Option {
        SHOW_USAGE,
        STACK_TRACE;

    }
}

