/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.ivy.util.FileUtil;
import org.springframework.boot.cli.Log;
import org.springframework.boot.cli.command.OptionHandler;
import org.springframework.boot.cli.command.OptionParsingCommand;

public class CleanCommand
extends OptionParsingCommand {
    public CleanCommand() {
        super("clean", "Clean up groovy grapes (useful if snapshots are needed and you need an update)", new CleanOptionHandler());
    }

    @Override
    public String getUsageHelp() {
        return "[options] <dependencies>";
    }

    private static class CleanOptionHandler
    extends OptionHandler {
        private OptionSpec<Void> allOption;
        private OptionSpec<Void> ivyOption;
        private OptionSpec<Void> mvnOption;

        private CleanOptionHandler() {
        }

        @Override
        protected void options() {
            this.allOption = this.option("all", "Clean all files (not just snapshots)");
            this.ivyOption = this.option("ivy", "Clean just ivy (grapes) cache. Default is on unless --maven is used.");
            this.mvnOption = this.option("maven", "Clean just maven cache. Default is off.");
        }

        @Override
        protected void run(OptionSet options) throws Exception {
            if (!options.has(this.ivyOption)) {
                this.clean(options, this.getGrapesHome(), Layout.IVY);
            }
            if (options.has(this.mvnOption)) {
                if (options.has(this.ivyOption)) {
                    this.clean(options, this.getGrapesHome(), Layout.IVY);
                }
                this.clean(options, this.getMavenHome(), Layout.MAVEN);
            }
        }

        private void clean(OptionSet options, File root, Layout layout) {
            if (root == null || !root.exists()) {
                return;
            }
            ArrayList specs = new ArrayList(options.nonOptionArguments());
            if (!specs.contains("org.springframework.boot") && layout == Layout.IVY) {
                specs.add(0, "org.springframework.boot");
            }
            for (Object spec : specs) {
                if (!(spec instanceof String)) continue;
                this.clean(options, root, layout, (String)spec);
            }
        }

        private void clean(OptionSet options, File root, Layout layout, String spec) {
            File file;
            String group = spec;
            String module = null;
            if (spec.contains(":")) {
                group = spec.substring(0, spec.indexOf(58));
                module = spec.substring(spec.indexOf(58) + 1);
            }
            if (!(file = this.getModulePath(root, group, module, layout)).exists()) {
                return;
            }
            if (options.has(this.allOption) || group.equals("org.springframework.boot")) {
                this.delete(file);
                return;
            }
            for (Object obj : FileUtil.listAll(file, Collections.emptyList())) {
                File candidate = (File)obj;
                if (!candidate.getName().contains("SNAPSHOT")) continue;
                this.delete(candidate);
            }
        }

        private void delete(File file) {
            Log.info("Deleting: " + file);
            FileUtil.forceDelete(file);
        }

        private File getModulePath(File root, String group, String module, Layout layout) {
            File parent = root;
            if (layout == Layout.IVY) {
                parent = new File(parent, group);
            } else {
                for (String path : group.split("\\.")) {
                    parent = new File(parent, path);
                }
            }
            if (module == null) {
                return parent;
            }
            return new File(parent, module);
        }

        private File getGrapesHome() {
            File home;
            String dir = System.getenv("GROOVY_HOME");
            String userdir = System.getProperty("user.home");
            if (dir == null || !new File(dir).exists()) {
                dir = userdir;
                home = new File(dir, ".groovy");
            } else {
                home = new File(dir);
            }
            if (dir == null || !new File(dir).exists()) {
                return null;
            }
            return new File(home, "grapes");
        }

        private File getMavenHome() {
            String dir = System.getProperty("user.home");
            if (dir == null || !new File(dir).exists()) {
                return null;
            }
            File home = new File(dir);
            return new File(new File(home, ".m2"), "repository");
        }

        private static enum Layout {
            IVY,
            MAVEN;

        }
    }
}

