/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command;

import java.awt.Desktop;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.springframework.boot.cli.command.OptionHandler;
import org.springframework.boot.cli.command.OptionParsingCommand;
import org.springframework.boot.cli.runner.SpringApplicationRunner;
import org.springframework.boot.cli.runner.SpringApplicationRunnerConfiguration;

public class RunCommand
extends OptionParsingCommand {
    public RunCommand() {
        super("run", "Run a spring groovy script", new RunOptionHandler());
    }

    @Override
    public String getUsageHelp() {
        return "[options] <files> [--] [args]";
    }

    public void stop() {
        if (this.getHandler() != null) {
            ((RunOptionHandler)this.getHandler()).runner.stop();
        }
    }

    private static class RunOptionHandler
    extends OptionHandler {
        private OptionSpec<Void> watchOption;
        private OptionSpec<Void> editOption;
        private OptionSpec<Void> noGuessImportsOption;
        private OptionSpec<Void> noGuessDependenciesOption;
        private OptionSpec<Void> verboseOption;
        private OptionSpec<Void> quietOption;
        private OptionSpec<Void> localOption;
        private OptionSpec<String> classpathOption;
        private SpringApplicationRunner runner;

        private RunOptionHandler() {
        }

        @Override
        protected void options() {
            this.watchOption = this.option("watch", "Watch the specified file for changes");
            this.localOption = this.option("local", "Accumulate the dependencies in a local folder (./grapes)");
            this.editOption = this.option(Arrays.asList("edit", "e"), "Open the file with the default system editor");
            this.noGuessImportsOption = this.option("no-guess-imports", "Do not attempt to guess imports");
            this.noGuessDependenciesOption = this.option("no-guess-dependencies", "Do not attempt to guess dependencies");
            this.verboseOption = this.option(Arrays.asList("verbose", "v"), "Verbose logging");
            this.quietOption = this.option(Arrays.asList("quiet", "q"), "Quiet logging");
            this.classpathOption = this.option(Arrays.asList("classpath", "cp"), "Additional classpath entries").withRequiredArg();
        }

        @Override
        protected void run(OptionSet options) throws Exception {
            SpringApplicationRunnerConfigurationAdapter configuration;
            List<?> nonOptionArguments = options.nonOptionArguments();
            File[] files = this.getFileArguments(nonOptionArguments);
            List<?> args = nonOptionArguments.subList(files.length, nonOptionArguments.size());
            if (options.has(this.editOption)) {
                Desktop.getDesktop().edit(files[0]);
            }
            if ((configuration = new SpringApplicationRunnerConfigurationAdapter(options)).isLocal() && System.getProperty("grape.root") == null) {
                System.setProperty("grape.root", ".");
            }
            this.runner = new SpringApplicationRunner(configuration, files, args.toArray(new String[args.size()]));
            this.runner.compileAndRun();
        }

        private File[] getFileArguments(List<?> nonOptionArguments) {
            ArrayList<File> files = new ArrayList<File>();
            for (Object option : nonOptionArguments) {
                File file;
                if (!(option instanceof String)) continue;
                String filename = (String)option;
                if ("--".equals(filename)) break;
                if (!filename.endsWith(".groovy") && !filename.endsWith(".java") || !(file = new File(filename)).isFile() || !file.canRead()) continue;
                files.add(file);
            }
            if (files.size() == 0) {
                throw new RuntimeException("Please specify a file to run");
            }
            return files.toArray(new File[files.size()]);
        }

        private class SpringApplicationRunnerConfigurationAdapter
        implements SpringApplicationRunnerConfiguration {
            private OptionSet options;

            public SpringApplicationRunnerConfigurationAdapter(OptionSet options) {
                this.options = options;
            }

            @Override
            public boolean isWatchForFileChanges() {
                return this.options.has(RunOptionHandler.this.watchOption);
            }

            @Override
            public boolean isGuessImports() {
                return !this.options.has(RunOptionHandler.this.noGuessImportsOption);
            }

            @Override
            public boolean isGuessDependencies() {
                return !this.options.has(RunOptionHandler.this.noGuessDependenciesOption);
            }

            @Override
            public boolean isLocal() {
                return this.options.has(RunOptionHandler.this.localOption);
            }

            @Override
            public Level getLogLevel() {
                if (this.options.has(RunOptionHandler.this.verboseOption)) {
                    return Level.FINEST;
                }
                if (this.options.has(RunOptionHandler.this.quietOption)) {
                    return Level.OFF;
                }
                return Level.INFO;
            }

            @Override
            public String getClasspath() {
                if (this.options.has(RunOptionHandler.this.classpathOption)) {
                    return (String)this.options.valueOf(RunOptionHandler.this.classpathOption);
                }
                return "";
            }
        }
    }
}

