/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import groovy.lang.Script;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import joptsimple.OptionParser;
import org.apache.ivy.util.FileUtil;
import org.codehaus.groovy.control.CompilationFailedException;
import org.springframework.boot.cli.Command;
import org.springframework.boot.cli.command.OptionHandler;
import org.springframework.boot.cli.command.ScriptCompilationCustomizer;
import org.springframework.boot.cli.compiler.GroovyCompiler;
import org.springframework.boot.cli.compiler.GroovyCompilerConfiguration;

public class ScriptCommand
implements Command {
    private static final String[] DEFAULT_PATHS = new String[]{"${SPRING_HOME}/ext", "${SPRING_HOME}/bin"};
    private String[] paths = DEFAULT_PATHS;
    private Class<?> mainClass;
    private Object main;
    private String name;

    public ScriptCommand(String script) {
        this.name = script;
    }

    @Override
    public String getName() {
        if (this.getMain() instanceof Command) {
            return ((Command)this.getMain()).getName();
        }
        return this.name;
    }

    @Override
    public String getDescription() {
        if (this.getMain() instanceof Command) {
            return ((Command)this.getMain()).getDescription();
        }
        return this.name;
    }

    @Override
    public String getHelp() {
        if (this.getMain() instanceof OptionHandler) {
            return ((OptionHandler)this.getMain()).getHelp();
        }
        if (this.getMain() instanceof Command) {
            return ((Command)this.getMain()).getHelp();
        }
        return null;
    }

    @Override
    public void run(String ... args) throws Exception {
        this.run(this.getMain(), args);
    }

    private void run(Object main, String[] args) throws Exception {
        if (main instanceof Command) {
            ((Command)main).run(args);
        } else if (main instanceof OptionHandler) {
            ((OptionHandler)this.getMain()).run(args);
        } else if (main instanceof Closure) {
            ((Closure)main).call(args);
        } else if (main instanceof Runnable) {
            ((Runnable)main).run();
        } else if (main instanceof Script) {
            OptionParser parser;
            GroovyObjectSupport object;
            Script script = (Script)this.main;
            script.setProperty("args", args);
            if (this.main instanceof GroovyObjectSupport && (object = (GroovyObjectSupport)this.main).getMetaClass().hasProperty(object, "parser") != null && (parser = (OptionParser)object.getProperty("parser")) != null) {
                script.setProperty("options", parser.parse(args));
            }
            Object result = script.run();
            this.run(result, args);
        }
    }

    public void setPaths(String[] paths) {
        this.paths = paths == null ? null : (String[])paths.clone();
    }

    @Override
    public String getUsageHelp() {
        if (this.getMain() instanceof Command) {
            return ((Command)this.getMain()).getDescription();
        }
        return "[options] <args>";
    }

    protected Object getMain() {
        if (this.main == null) {
            GroovyObjectSupport object;
            MetaClass metaClass;
            MetaMethod options;
            try {
                this.main = this.getMainClass().newInstance();
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot create main class: " + this.name, ex);
            }
            if (this.main instanceof OptionHandler) {
                ((OptionHandler)this.main).options();
            } else if (this.main instanceof GroovyObjectSupport && (options = (metaClass = (object = (GroovyObjectSupport)this.main).getMetaClass()).getMetaMethod("options", null)) != null) {
                options.doMethodInvoke(this.main, null);
            }
        }
        return this.main;
    }

    private void compile() {
        Class<?>[] classes;
        GroovyCompiler compiler = new GroovyCompiler(new ScriptConfiguration());
        compiler.addCompilationCustomizers(new ScriptCompilationCustomizer());
        File source = this.locateSource(this.name);
        try {
            classes = compiler.compile(source);
        }
        catch (CompilationFailedException ex) {
            throw new IllegalStateException("Could not compile script", ex);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not compile script", ex);
        }
        this.mainClass = classes[0];
    }

    private Class<?> getMainClass() {
        if (this.mainClass == null) {
            this.compile();
        }
        return this.mainClass;
    }

    private File locateSource(String name) {
        URL url;
        String resource = name;
        if (!name.endsWith(".groovy")) {
            resource = "commands/" + name + ".groovy";
        }
        if ((url = this.getClass().getClassLoader().getResource(resource)) != null) {
            return this.locateSourceFromUrl(name, url);
        }
        String home = System.getProperty("SPRING_HOME", System.getenv("SPRING_HOME"));
        if (home == null) {
            home = ".";
        }
        for (String path : this.paths) {
            String subbed = path.replace("${SPRING_HOME}", home);
            File file = new File(subbed, resource);
            if (!file.exists()) continue;
            return file;
        }
        throw new IllegalStateException("No script found for : " + name);
    }

    private File locateSourceFromUrl(String name, URL url) {
        if (url.toString().startsWith("file:")) {
            return new File(url.toString().substring("file:".length()));
        }
        try {
            File file = File.createTempFile(name, ".groovy");
            file.deleteOnExit();
            FileUtil.copy(url, file, null);
            return file;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not create temp file for source: " + name);
        }
    }

    private static class ScriptConfiguration
    implements GroovyCompilerConfiguration {
        private ScriptConfiguration() {
        }

        @Override
        public boolean isGuessImports() {
            return true;
        }

        @Override
        public boolean isGuessDependencies() {
            return true;
        }

        @Override
        public String getClasspath() {
            return "";
        }
    }
}

