/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command;

import groovy.lang.Mixin;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.springframework.boot.cli.Command;
import org.springframework.boot.cli.command.OptionHandler;
import org.springframework.boot.cli.command.OptionParsingCommand;

public class ScriptCompilationCustomizer
extends CompilationCustomizer {
    public ScriptCompilationCustomizer() {
        super(CompilePhase.CONVERSION);
    }

    @Override
    public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
        this.addOptionHandlerMixin(classNode);
        this.overrideOptionsMethod(source, classNode);
        this.addImports(source, context, classNode);
    }

    private void addImports(SourceUnit source, GeneratorContext context, ClassNode classNode) {
        ImportCustomizer importCustomizer = new ImportCustomizer();
        importCustomizer.addImports("joptsimple.OptionParser", "joptsimple.OptionSet", OptionParsingCommand.class.getCanonicalName(), Command.class.getCanonicalName(), OptionHandler.class.getCanonicalName());
        importCustomizer.call(source, context, classNode);
    }

    private void overrideOptionsMethod(SourceUnit source, ClassNode classNode) {
        BlockStatement block = source.getAST().getStatementBlock();
        List<Statement> statements = block.getStatements();
        for (Statement statement : new ArrayList<Statement>(statements)) {
            ArgumentListExpression arguments;
            MethodCallExpression method;
            ExpressionStatement expr;
            Expression expression;
            if (!(statement instanceof ExpressionStatement) || !((expression = (expr = (ExpressionStatement)statement).getExpression()) instanceof MethodCallExpression) || !(method = (MethodCallExpression)expression).getMethod().getText().equals("options") || !((expression = method.getArguments()) instanceof ArgumentListExpression) || !((expression = (arguments = (ArgumentListExpression)expression).getExpression(0)) instanceof ClosureExpression)) continue;
            ClosureExpression closure = (ClosureExpression)expression;
            classNode.addMethod(new MethodNode("options", 4, ClassHelper.VOID_TYPE, new Parameter[0], new ClassNode[0], closure.getCode()));
            statements.remove(statement);
        }
    }

    private void addOptionHandlerMixin(ClassNode classNode) {
        if (!classNode.isDerivedFrom(ClassHelper.make(OptionHandler.class)) && !classNode.isDerivedFrom(ClassHelper.make("OptionHandler"))) {
            AnnotationNode mixin = new AnnotationNode(ClassHelper.make(Mixin.class));
            mixin.addMember("value", new ClassExpression(ClassHelper.make(OptionHandler.class)));
            classNode.addAnnotation(mixin);
        }
    }
}

