/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler;

import groovy.grape.Grape;
import groovy.lang.GroovyClassLoader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DependencyCustomizer {
    private final GroovyClassLoader loader;
    private final List<Map<String, Object>> dependencies;
    private Properties properties;

    public DependencyCustomizer(GroovyClassLoader loader) {
        this.loader = loader;
        this.dependencies = new ArrayList<Map<String, Object>>();
    }

    protected DependencyCustomizer(DependencyCustomizer parent) {
        this.loader = parent.loader;
        this.dependencies = parent.dependencies;
    }

    public String getProperty(String key) {
        return this.getProperty(key, "");
    }

    public String getProperty(String key, String defaultValue) {
        if (this.properties == null) {
            this.properties = new Properties();
            try {
                for (URL url : Collections.list(this.loader.getResources("META-INF/springcli.properties"))) {
                    this.properties.load(url.openStream());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.properties.getProperty(key, defaultValue);
    }

    public DependencyCustomizer ifAnyMissingClasses(final String ... classNames) {
        return new DependencyCustomizer(this){

            @Override
            protected boolean canAdd() {
                for (String classname : classNames) {
                    try {
                        DependencyCustomizer.this.loader.loadClass(classname);
                    }
                    catch (Exception ex) {
                        return true;
                    }
                }
                return DependencyCustomizer.this.canAdd();
            }
        };
    }

    public DependencyCustomizer ifAllMissingClasses(final String ... classNames) {
        return new DependencyCustomizer(this){

            @Override
            protected boolean canAdd() {
                for (String classname : classNames) {
                    try {
                        DependencyCustomizer.this.loader.loadClass(classname);
                        return false;
                    }
                    catch (Exception ex) {
                    }
                }
                return DependencyCustomizer.this.canAdd();
            }
        };
    }

    public DependencyCustomizer ifAllResourcesPresent(final String ... paths) {
        return new DependencyCustomizer(this){

            @Override
            protected boolean canAdd() {
                for (String path : paths) {
                    try {
                        return DependencyCustomizer.this.loader.getResource(path) != null;
                    }
                    catch (Exception ex) {
                    }
                }
                return DependencyCustomizer.this.canAdd();
            }
        };
    }

    public DependencyCustomizer ifAnyResourcesPresent(final String ... paths) {
        return new DependencyCustomizer(this){

            @Override
            protected boolean canAdd() {
                for (String path : paths) {
                    try {
                        return DependencyCustomizer.this.loader.getResource(path) != null;
                    }
                    catch (Exception ex) {
                    }
                }
                return DependencyCustomizer.this.canAdd();
            }
        };
    }

    public DependencyCustomizer ifNotAdded(final String group, final String module) {
        return new DependencyCustomizer(this){

            @Override
            protected boolean canAdd() {
                if (DependencyCustomizer.this.contains(group, module)) {
                    return false;
                }
                return DependencyCustomizer.this.canAdd();
            }
        };
    }

    protected boolean contains(String group, String module) {
        for (Map<String, Object> dependency : this.dependencies) {
            if (!group.equals(dependency.get("group")) || !module.equals(dependency.get("module"))) continue;
            return true;
        }
        return false;
    }

    public DependencyCustomizer add(String group, String module, String version) {
        return this.add(group, module, version, true);
    }

    public DependencyCustomizer add(String group, String module, String version, boolean transitive) {
        if (this.canAdd()) {
            HashMap<String, Object> dependency = new HashMap<String, Object>();
            dependency.put("group", group);
            dependency.put("module", module);
            dependency.put("version", version);
            dependency.put("transitive", transitive);
            return this.add(dependency);
        }
        return this;
    }

    public DependencyCustomizer add(Map<String, Object> ... dependencies) {
        this.dependencies.addAll(Arrays.asList(dependencies));
        return this;
    }

    protected boolean canAdd() {
        return true;
    }

    void call() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("classLoader", this.loader);
        Grape.grab(args, this.dependencies.toArray(new Map[this.dependencies.size()]));
    }
}

