/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler;

import groovy.lang.GroovyClassLoader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;

class ExtendedGroovyClassLoader
extends GroovyClassLoader {
    private Map<String, byte[]> classResources = new HashMap<String, byte[]>();
    private CompilerConfiguration configuration;

    public ExtendedGroovyClassLoader(ClassLoader loader, CompilerConfiguration config) {
        super(loader, config);
        this.configuration = config;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream resourceStream = super.getResourceAsStream(name);
        if (resourceStream == null) {
            byte[] bytes = this.classResources.get(name);
            resourceStream = bytes == null ? null : new ByteArrayInputStream(bytes);
        }
        return resourceStream;
    }

    public CompilerConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public GroovyClassLoader.ClassCollector createCollector(CompilationUnit unit, SourceUnit su) {
        GroovyClassLoader.InnerLoader loader = AccessController.doPrivileged(new PrivilegedAction<GroovyClassLoader.InnerLoader>(){

            @Override
            public GroovyClassLoader.InnerLoader run() {
                return new GroovyClassLoader.InnerLoader(ExtendedGroovyClassLoader.this);
            }
        });
        return new ExtendedClassCollector(loader, unit, su);
    }

    protected class ExtendedClassCollector
    extends GroovyClassLoader.ClassCollector {
        protected ExtendedClassCollector(GroovyClassLoader.InnerLoader loader, CompilationUnit unit, SourceUnit su) {
            super(loader, unit, su);
        }

        @Override
        protected Class<?> createClass(byte[] code, ClassNode classNode) {
            Class createdClass = super.createClass(code, classNode);
            ExtendedGroovyClassLoader.this.classResources.put(classNode.getName().replace(".", "/") + ".class", code);
            return createdClass;
        }
    }
}

