/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler;

import groovy.grape.Grape;
import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ServiceLoader;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.springframework.boot.cli.compiler.CompilerAutoConfiguration;
import org.springframework.boot.cli.compiler.DependencyCustomizer;
import org.springframework.boot.cli.compiler.ExtendedGroovyClassLoader;
import org.springframework.boot.cli.compiler.GrapeEngineCustomizer;
import org.springframework.boot.cli.compiler.GroovyCompilerConfiguration;

public class GroovyCompiler {
    private GroovyCompilerConfiguration configuration;
    private ExtendedGroovyClassLoader loader;

    public GroovyCompiler(GroovyCompilerConfiguration configuration) {
        this.configuration = configuration;
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        this.loader = new ExtendedGroovyClassLoader(this.getClass().getClassLoader(), compilerConfiguration);
        if (configuration.getClasspath().length() > 0) {
            this.loader.addClasspath(configuration.getClasspath());
        }
        new GrapeEngineCustomizer(Grape.getInstance()).customize();
        compilerConfiguration.addCompilationCustomizers(new CompilerAutoConfigureCustomizer());
    }

    public void addCompilationCustomizers(CompilationCustomizer ... customizers) {
        this.loader.getConfiguration().addCompilationCustomizers(customizers);
    }

    public Object[] sources(File ... files) throws CompilationFailedException, IOException {
        ArrayList<File> compilables = new ArrayList<File>();
        ArrayList<Serializable> others = new ArrayList<Serializable>();
        for (File file : files) {
            if (file.getName().endsWith(".groovy") || file.getName().endsWith(".java")) {
                compilables.add(file);
                continue;
            }
            others.add(file);
        }
        Class<?>[] compiled = this.compile(compilables.toArray(new File[compilables.size()]));
        others.addAll(0, Arrays.asList(compiled));
        return others.toArray(new Object[others.size()]);
    }

    public Class<?>[] compile(File ... file) throws CompilationFailedException, IOException {
        this.loader.clearCache();
        ArrayList<Class> classes = new ArrayList<Class>();
        CompilerConfiguration compilerConfiguration = this.loader.getConfiguration();
        CompilationUnit compilationUnit = new CompilationUnit(compilerConfiguration, null, this.loader);
        SourceUnit sourceUnit = new SourceUnit(file[0], compilerConfiguration, (GroovyClassLoader)this.loader, compilationUnit.getErrorCollector());
        GroovyClassLoader.ClassCollector collector = this.loader.createCollector(compilationUnit, sourceUnit);
        compilationUnit.setClassgenCallback(collector);
        compilationUnit.addSources(file);
        compilationUnit.compile(7);
        for (Object loadedClass : collector.getLoadedClasses()) {
            classes.add((Class)loadedClass);
        }
        ClassNode mainClassNode = (ClassNode)compilationUnit.getAST().getClasses().get(0);
        Class mainClass = null;
        for (Class loadedClass : classes) {
            if (!mainClassNode.getName().equals(loadedClass.getName())) continue;
            mainClass = loadedClass;
        }
        if (mainClass != null) {
            classes.remove(mainClass);
            classes.add(0, mainClass);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private class CompilerAutoConfigureCustomizer
    extends CompilationCustomizer {
        public CompilerAutoConfigureCustomizer() {
            super(CompilePhase.CONVERSION);
        }

        @Override
        public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
            ImportCustomizer importCustomizer = new ImportCustomizer();
            ServiceLoader<CompilerAutoConfiguration> customizers = ServiceLoader.load(CompilerAutoConfiguration.class, GroovyCompiler.class.getClassLoader());
            DependencyCustomizer dependencyCustomizer = new DependencyCustomizer(GroovyCompiler.this.loader);
            for (CompilerAutoConfiguration autoConfiguration : customizers) {
                if (!autoConfiguration.matches(classNode) || !GroovyCompiler.this.configuration.isGuessDependencies()) continue;
                autoConfiguration.applyDependencies(dependencyCustomizer);
            }
            dependencyCustomizer.call();
            for (CompilerAutoConfiguration autoConfiguration : customizers) {
                if (!autoConfiguration.matches(classNode)) continue;
                if (GroovyCompiler.this.configuration.isGuessImports()) {
                    autoConfiguration.applyImports(importCustomizer);
                    importCustomizer.call(source, context, classNode);
                }
                if (source.getAST().getClasses().size() > 0 && classNode.equals(source.getAST().getClasses().get(0))) {
                    autoConfiguration.applyToMainClass(GroovyCompiler.this.loader, GroovyCompiler.this.configuration, context, source, classNode);
                }
                autoConfiguration.apply(GroovyCompiler.this.loader, GroovyCompiler.this.configuration, context, source, classNode);
            }
            importCustomizer.call(source, context, classNode);
        }
    }
}

