/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler.autoconfigure;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.springframework.boot.cli.compiler.AstUtils;
import org.springframework.boot.cli.compiler.CompilerAutoConfiguration;
import org.springframework.boot.cli.compiler.DependencyCustomizer;

public class ReactorCompilerAutoConfiguration
extends CompilerAutoConfiguration {
    @Override
    public boolean matches(ClassNode classNode) {
        return AstUtils.hasAtLeastOneAnnotation(classNode, "EnableReactor");
    }

    @Override
    public void applyDependencies(DependencyCustomizer dependencies) {
        dependencies.ifAnyMissingClasses("org.reactor.Reactor").add("org.projectreactor", "reactor-spring", dependencies.getProperty("reactor.version"), false).add("org.projectreactor", "reactor-core", dependencies.getProperty("reactor.version"));
    }

    @Override
    public void applyImports(ImportCustomizer imports) {
        imports.addImports("reactor.core.Reactor", "reactor.event.Event", "reactor.function.Consumer", "reactor.function.Functions", "reactor.event.selector.Selectors", "reactor.spring.context.annotation.On", "reactor.spring.context.annotation.Reply", EnableReactor.class.getCanonicalName()).addStarImports("reactor.event.Selectors");
    }

    @Target(value={ElementType.TYPE})
    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface EnableReactor {
    }
}

