/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler.autoconfigure;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.springframework.boot.cli.compiler.AstUtils;
import org.springframework.boot.cli.compiler.CompilerAutoConfiguration;
import org.springframework.boot.cli.compiler.DependencyCustomizer;

public class SpringIntegrationCompilerAutoConfiguration
extends CompilerAutoConfiguration {
    @Override
    public boolean matches(ClassNode classNode) {
        return AstUtils.hasAtLeastOneAnnotation(classNode, "MessageEndpoint", "EnableIntegrationPatterns");
    }

    @Override
    public void applyDependencies(DependencyCustomizer dependencies) {
        dependencies.ifAnyMissingClasses("org.springframework.integration.Message").add("org.springframework.integration", "spring-integration-core", dependencies.getProperty("spring.integration.version")).add("org.springframework.integration", "spring-integration-dsl-groovy-core", dependencies.getProperty("spring.integration.dsl.version", "1.0.0.M1"));
        dependencies.ifAnyMissingClasses("groovy.util.XmlParser").add("org.codehaus.groovy", "groovy-xml", dependencies.getProperty("groovy.version"));
    }

    @Override
    public void applyImports(ImportCustomizer imports) {
        imports.addImports("org.springframework.integration.Message", "org.springframework.integration.support.MessageBuilder", "org.springframework.integration.MessageChannel", "org.springframework.integration.MessageHeaders", "org.springframework.integration.annotation.MessageEndpoint", "org.springframework.integration.annotation.Header", "org.springframework.integration.annotation.Headers", "org.springframework.integration.annotation.Payload", "org.springframework.integration.annotation.Payloads", EnableIntegrationPatterns.class.getCanonicalName(), "org.springframework.integration.dsl.groovy.MessageFlow", "org.springframework.integration.dsl.groovy.builder.IntegrationBuilder");
    }

    @Target(value={ElementType.TYPE})
    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface EnableIntegrationPatterns {
    }
}

