/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler.autoconfigure;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.springframework.boot.cli.compiler.AstUtils;
import org.springframework.boot.cli.compiler.CompilerAutoConfiguration;
import org.springframework.boot.cli.compiler.DependencyCustomizer;

public class SpringMvcCompilerAutoConfiguration
extends CompilerAutoConfiguration {
    @Override
    public void applyDependencies(DependencyCustomizer dependencies) {
        dependencies.ifAnyMissingClasses("org.springframework.web.servlet.mvc.Controller").add("org.springframework", "spring-webmvc", dependencies.getProperty("spring.version"));
        dependencies.ifAnyMissingClasses("org.eclipse.jetty.server.Server").add("org.eclipse.jetty", "jetty-webapp", dependencies.getProperty("jetty.version"));
        dependencies.add("org.codehaus.groovy", "groovy-templates", dependencies.getProperty("groovy.version"));
    }

    @Override
    public boolean matches(ClassNode classNode) {
        return AstUtils.hasAtLeastOneAnnotation(classNode, "Controller", "EnableWebMvc");
    }

    @Override
    public void applyImports(ImportCustomizer imports) {
        imports.addStarImports("org.springframework.web.bind.annotation", "org.springframework.web.servlet.config.annotation", "org.springframework.web.servlet", "org.springframework.web.servlet.handler", "org.springframework.http");
        imports.addStaticImport("org.springframework.boot.cli.template.GroovyTemplate", "template");
    }
}

