/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler.autoconfigure;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.springframework.boot.cli.compiler.AstUtils;
import org.springframework.boot.cli.compiler.CompilerAutoConfiguration;
import org.springframework.boot.cli.compiler.DependencyCustomizer;

public class SpringSecurityCompilerAutoConfiguration
extends CompilerAutoConfiguration {
    @Override
    public boolean matches(ClassNode classNode) {
        return AstUtils.hasAtLeastOneAnnotation(classNode, "EnableWebSecurity");
    }

    @Override
    public void applyDependencies(DependencyCustomizer dependencies) {
        dependencies.ifAnyMissingClasses("org.springframework.security.config.annotation.web.configuration.EnableWebSecurity").add("org.springframework.security", "spring-security-config", dependencies.getProperty("spring.security.version")).add("org.springframework.security", "spring-security-web", dependencies.getProperty("spring.security.version"), false);
    }

    @Override
    public void applyImports(ImportCustomizer imports) {
        imports.addImports("org.springframework.security.core.Authentication", "org.springframework.security.core.authority.AuthorityUtils").addStarImports("org.springframework.security.config.annotation.web.configuration", "org.springframework.security.authentication", "org.springframework.security.config.annotation.web", "org.springframework.security.config.annotation.web.builders");
    }
}

