/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.runner;

import java.io.File;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.springframework.boot.cli.compiler.GroovyCompiler;
import org.springframework.boot.cli.runner.SpringApplicationRunnerConfiguration;

public class SpringApplicationRunner {
    private static int watcherCounter = 0;
    private static int runnerCounter = 0;
    private SpringApplicationRunnerConfiguration configuration;
    private final File[] files;
    private final String[] args;
    private final GroovyCompiler compiler;
    private RunThread runThread;
    private FileWatchThread fileWatchThread;

    public SpringApplicationRunner(SpringApplicationRunnerConfiguration configuration, File[] files, String ... args) {
        this.configuration = configuration;
        this.files = (File[])files.clone();
        this.args = (String[])args.clone();
        this.compiler = new GroovyCompiler(configuration);
        if (configuration.getLogLevel().intValue() <= Level.FINE.intValue()) {
            System.setProperty("groovy.grape.report.downloads", "true");
        }
    }

    public synchronized void compileAndRun() throws Exception {
        try {
            this.stop();
            Object[] sources = this.compiler.sources(this.files);
            if (sources.length == 0) {
                throw new RuntimeException("No classes found in '" + this.files + "'");
            }
            this.runThread = new RunThread(sources);
            this.runThread.start();
            this.runThread.join();
            if (this.fileWatchThread == null && this.configuration.isWatchForFileChanges()) {
                this.fileWatchThread = new FileWatchThread();
                this.fileWatchThread.start();
            }
        }
        catch (Exception ex) {
            if (this.fileWatchThread == null) {
                throw ex;
            }
            ex.printStackTrace();
        }
    }

    public void stop() {
        if (this.runThread != null) {
            this.runThread.shutdown();
            this.runThread = null;
        }
    }

    private class FileWatchThread
    extends Thread {
        private long previous;

        public FileWatchThread() {
            super("filewatcher-" + watcherCounter++);
            this.previous = 0L;
            for (File file : SpringApplicationRunner.this.files) {
                long current = file.lastModified();
                if (current <= this.previous) continue;
                this.previous = current;
            }
            this.setDaemon(false);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    block4: while (true) {
                        Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
                        File[] arr$ = SpringApplicationRunner.this.files;
                        int len$ = arr$.length;
                        int i$ = 0;
                        while (true) {
                            if (i$ >= len$) continue block4;
                            File file = arr$[i$];
                            long current = file.lastModified();
                            if (this.previous < current) {
                                this.previous = current;
                                SpringApplicationRunner.this.compileAndRun();
                            }
                            ++i$;
                        }
                        break;
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }

    private class RunThread
    extends Thread {
        private final Object[] sources;
        private Object applicationContext;

        public RunThread(Object ... sources) {
            super("runner-" + runnerCounter++);
            this.sources = sources;
            if (sources.length != 0 && sources[0] instanceof Class) {
                this.setContextClassLoader(((Class)sources[0]).getClassLoader());
            }
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                Class<?> application = this.getContextClassLoader().loadClass("org.springframework.boot.SpringApplication");
                Method method = application.getMethod("run", Object[].class, String[].class);
                this.applicationContext = method.invoke(null, this.sources, SpringApplicationRunner.this.args);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void shutdown() {
            if (this.applicationContext != null) {
                try {
                    Method method = this.applicationContext.getClass().getMethod("close", new Class[0]);
                    method.invoke(this.applicationContext, new Object[0]);
                }
                catch (NoSuchMethodException ex) {
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    this.applicationContext = null;
                }
            }
        }
    }
}

