/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.beans.Mergeable;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.DefaultMvcResult;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.util.Assert;

public final class MockMvc {
    static String MVC_RESULT_ATTRIBUTE = MockMvc.class.getName().concat(".MVC_RESULT_ATTRIBUTE");
    private final MockFilterChain filterChain;
    private final ServletContext servletContext;
    private RequestBuilder defaultRequestBuilder;
    private List<ResultMatcher> defaultResultMatchers = new ArrayList<ResultMatcher>();
    private List<ResultHandler> defaultResultHandlers = new ArrayList<ResultHandler>();

    MockMvc(MockFilterChain filterChain, ServletContext servletContext) {
        Assert.notNull((Object)servletContext, (String)"A ServletContext is required");
        Assert.notNull((Object)filterChain, (String)"A MockFilterChain is required");
        this.filterChain = filterChain;
        this.servletContext = servletContext;
    }

    void setDefaultRequest(RequestBuilder requestBuilder) {
        this.defaultRequestBuilder = requestBuilder;
    }

    void setGlobalResultMatchers(List<ResultMatcher> resultMatchers) {
        Assert.notNull(resultMatchers, (String)"resultMatchers is required");
        this.defaultResultMatchers = resultMatchers;
    }

    void setGlobalResultHandlers(List<ResultHandler> resultHandlers) {
        Assert.notNull(resultHandlers, (String)"resultHandlers is required");
        this.defaultResultHandlers = resultHandlers;
    }

    public ResultActions perform(RequestBuilder requestBuilder) throws Exception {
        if (this.defaultRequestBuilder != null && requestBuilder instanceof Mergeable) {
            requestBuilder = (RequestBuilder)((Mergeable)requestBuilder).merge((Object)this.defaultRequestBuilder);
        }
        MockHttpServletRequest request = requestBuilder.buildRequest(this.servletContext);
        MockHttpServletResponse response = new MockHttpServletResponse();
        final DefaultMvcResult mvcResult = new DefaultMvcResult(request, response);
        request.setAttribute(MVC_RESULT_ATTRIBUTE, mvcResult);
        this.filterChain.reset();
        this.filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        this.applyDefaultResultActions(mvcResult);
        return new ResultActions(){

            @Override
            public ResultActions andExpect(ResultMatcher matcher) throws Exception {
                matcher.match(mvcResult);
                return this;
            }

            @Override
            public ResultActions andDo(ResultHandler printer) throws Exception {
                printer.handle(mvcResult);
                return this;
            }

            @Override
            public MvcResult andReturn() {
                return mvcResult;
            }
        };
    }

    private void applyDefaultResultActions(MvcResult mvcResult) throws Exception {
        for (ResultMatcher matcher : this.defaultResultMatchers) {
            matcher.match(mvcResult);
        }
        for (ResultHandler handler : this.defaultResultHandlers) {
            handler.handle(mvcResult);
        }
    }
}

