/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart;

import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.boot.devtools.restart.ChangeableUrls;
import org.springframework.boot.devtools.restart.RestartInitializer;

public class DefaultRestartInitializer
implements RestartInitializer {
    private static final Set<String> SKIPPED_STACK_ELEMENTS;

    @Override
    public URL[] getInitialUrls(Thread thread) {
        if (!this.isMain(thread)) {
            return null;
        }
        for (StackTraceElement element : thread.getStackTrace()) {
            if (!this.isSkippedStackElement(element)) continue;
            return null;
        }
        return this.getUrls(thread);
    }

    protected boolean isMain(Thread thread) {
        return thread.getName().equals("main") && thread.getContextClassLoader().getClass().getName().contains("AppClassLoader");
    }

    private boolean isSkippedStackElement(StackTraceElement element) {
        for (String skipped : SKIPPED_STACK_ELEMENTS) {
            if (!element.getClassName().startsWith(skipped)) continue;
            return true;
        }
        return false;
    }

    protected URL[] getUrls(Thread thread) {
        return ChangeableUrls.fromClassLoader(thread.getContextClassLoader()).toArray();
    }

    static {
        LinkedHashSet<String> skipped = new LinkedHashSet<String>();
        skipped.add("org.junit.runners.");
        skipped.add("org.springframework.boot.test.");
        skipped.add("cucumber.runtime.");
        SKIPPED_STACK_ELEMENTS = Collections.unmodifiableSet(skipped);
    }
}

