/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.autoconfigure;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.core.Ordered;

public class EagerInitializationAutoConfiguration {
    @Bean
    public static AlwaysEagerBeanFactoryPostProcessor alwaysEagerBeanFactoryPostProcessor() {
        return new AlwaysEagerBeanFactoryPostProcessor();
    }

    private static final class AlwaysEagerBeanFactoryPostProcessor
    implements BeanFactoryPostProcessor,
    Ordered {
        private AlwaysEagerBeanFactoryPostProcessor() {
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            for (String name : beanFactory.getBeanDefinitionNames()) {
                BeanDefinition beanDefinition = beanFactory.getBeanDefinition(name);
                String factoryBeanName = beanDefinition.getFactoryBeanName();
                if (factoryBeanName == null || !factoryBeanName.startsWith("org.springframework.boot.devtools")) continue;
                beanDefinition.setLazyInit(false);
            }
        }

        public int getOrder() {
            return -2147483647;
        }
    }
}

