/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc.autoconfigure;

import com.zaxxer.hikari.HikariConfigMXBean;
import com.zaxxer.hikari.HikariDataSource;
import oracle.jdbc.OracleConnection;
import oracle.ucp.jdbc.PoolDataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceMXBean;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.jmx.ConnectionPoolMBean;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.jdbc.DataSourceUnwrapper;
import org.springframework.boot.jdbc.metadata.CommonsDbcp2DataSourcePoolMetadata;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.boot.jdbc.metadata.HikariDataSourcePoolMetadata;
import org.springframework.boot.jdbc.metadata.OracleUcpDataSourcePoolMetadata;
import org.springframework.boot.jdbc.metadata.TomcatDataSourcePoolMetadata;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportRuntimeHints;

@Configuration(proxyBeanMethods=false)
public class DataSourcePoolMetadataProvidersConfiguration {

    static class HikariDataSourcePoolMetadataRuntimeHints
    implements RuntimeHintsRegistrar {
        HikariDataSourcePoolMetadataRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            hints.reflection().registerType(HikariDataSource.class, builder -> builder.withField("pool"));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={PoolDataSource.class, OracleConnection.class})
    static class OracleUcpPoolDataSourceMetadataProviderConfiguration {
        OracleUcpPoolDataSourceMetadataProviderConfiguration() {
        }

        @Bean
        DataSourcePoolMetadataProvider oracleUcpPoolDataSourceMetadataProvider() {
            return dataSource -> {
                PoolDataSource ucpDataSource = DataSourceUnwrapper.unwrap(dataSource, PoolDataSource.class);
                if (ucpDataSource != null) {
                    return new OracleUcpDataSourcePoolMetadata(ucpDataSource);
                }
                return null;
            };
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={BasicDataSource.class})
    static class CommonsDbcp2PoolDataSourceMetadataProviderConfiguration {
        CommonsDbcp2PoolDataSourceMetadataProviderConfiguration() {
        }

        @Bean
        DataSourcePoolMetadataProvider commonsDbcp2PoolDataSourceMetadataProvider() {
            return dataSource -> {
                BasicDataSource dbcpDataSource = DataSourceUnwrapper.unwrap(dataSource, BasicDataSourceMXBean.class, BasicDataSource.class);
                if (dbcpDataSource != null) {
                    return new CommonsDbcp2DataSourcePoolMetadata(dbcpDataSource);
                }
                return null;
            };
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HikariDataSource.class})
    @ImportRuntimeHints(value={HikariDataSourcePoolMetadataRuntimeHints.class})
    static class HikariPoolDataSourceMetadataProviderConfiguration {
        HikariPoolDataSourceMetadataProviderConfiguration() {
        }

        @Bean
        DataSourcePoolMetadataProvider hikariPoolDataSourceMetadataProvider() {
            return dataSource -> {
                HikariDataSource hikariDataSource = DataSourceUnwrapper.unwrap(dataSource, HikariConfigMXBean.class, HikariDataSource.class);
                if (hikariDataSource != null) {
                    return new HikariDataSourcePoolMetadata(hikariDataSource);
                }
                return null;
            };
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={DataSource.class})
    static class TomcatDataSourcePoolMetadataProviderConfiguration {
        TomcatDataSourcePoolMetadataProviderConfiguration() {
        }

        @Bean
        DataSourcePoolMetadataProvider tomcatPoolDataSourceMetadataProvider() {
            return dataSource -> {
                DataSource tomcatDataSource = DataSourceUnwrapper.unwrap(dataSource, ConnectionPoolMBean.class, DataSource.class);
                if (tomcatDataSource != null) {
                    return new TomcatDataSourcePoolMetadata(tomcatDataSource);
                }
                return null;
            };
        }
    }
}

