/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;

class JsonLoader {
    private final Class<?> resourceLoadClass;

    JsonLoader(Class<?> resourceLoadClass) {
        this.resourceLoadClass = resourceLoadClass;
    }

    public Class<?> getResourceLoadClass() {
        return this.resourceLoadClass;
    }

    public String getJson(CharSequence source) {
        if (source == null) {
            return null;
        }
        if (source.toString().endsWith(".json")) {
            return this.getJson((Resource)new ClassPathResource(source.toString(), this.resourceLoadClass));
        }
        return source.toString();
    }

    public String getJson(String path, Class<?> resourceLoadClass) {
        return this.getJson((Resource)new ClassPathResource(path, resourceLoadClass));
    }

    public String getJson(byte[] source) {
        return this.getJson(new ByteArrayInputStream(source));
    }

    public String getJson(File source) {
        try {
            return this.getJson(new FileInputStream(source));
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to load JSON from " + source, ex);
        }
    }

    public String getJson(Resource source) {
        try {
            return this.getJson(source.getInputStream());
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to load JSON from " + source, ex);
        }
    }

    public String getJson(InputStream source) {
        try {
            return FileCopyUtils.copyToString((Reader)new InputStreamReader(source));
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to load JSON from InputStream", ex);
        }
    }
}

