/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.system;

import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.springframework.boot.test.system.CapturedOutput;
import org.springframework.boot.test.system.OutputCapture;

public class OutputCaptureExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    private final OutputCapture outputCapture = new OutputCapture();

    OutputCaptureExtension() {
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.outputCapture.push();
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.outputCapture.pop();
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.outputCapture.push();
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.outputCapture.pop();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return CapturedOutput.class.equals(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.outputCapture;
    }
}

