/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.system;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.springframework.boot.test.system.OutputCapture;

public class OutputCaptureRule
implements TestRule {
    private final OutputCapture delegate = new OutputCapture();
    private List<Matcher<? super String>> matchers = new ArrayList<Matcher<? super String>>();

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                OutputCaptureRule.this.delegate.push();
                try {
                    base.evaluate();
                }
                finally {
                    try {
                        if (!OutputCaptureRule.this.matchers.isEmpty()) {
                            String output = OutputCaptureRule.this.delegate.toString();
                            Assert.assertThat((Object)output, (Matcher)Matchers.allOf((Iterable)OutputCaptureRule.this.matchers));
                        }
                    }
                    finally {
                        OutputCaptureRule.this.delegate.pop();
                    }
                }
            }
        };
    }

    @Deprecated
    public void reset() {
        this.delegate.reset();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public void expect(Matcher<? super String> matcher) {
        this.matchers.add(matcher);
    }
}

