/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.bind;

import java.util.EnumSet;
import java.util.Locale;
import org.springframework.boot.bind.RelaxedNames;
import org.springframework.boot.bind.StringToCharArrayConverter;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.util.Assert;

class RelaxedConversionService
implements ConversionService {
    private final ConversionService conversionService;
    private final GenericConversionService additionalConverters;

    RelaxedConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
        this.additionalConverters = new GenericConversionService();
        DefaultConversionService.addCollectionConverters((ConverterRegistry)this.additionalConverters);
        this.additionalConverters.addConverterFactory((ConverterFactory)new StringToEnumIgnoringCaseConverterFactory());
        this.additionalConverters.addConverter((Converter)new StringToCharArrayConverter());
    }

    public boolean canConvert(Class<?> sourceType, Class<?> targetType) {
        return this.conversionService != null && this.conversionService.canConvert(sourceType, targetType) || this.additionalConverters.canConvert(sourceType, targetType);
    }

    public boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.conversionService != null && this.conversionService.canConvert(sourceType, targetType) || this.additionalConverters.canConvert(sourceType, targetType);
    }

    public <T> T convert(Object source, Class<T> targetType) {
        Assert.notNull(targetType, (String)"The targetType to convert to cannot be null");
        return (T)this.convert(source, TypeDescriptor.forObject((Object)source), TypeDescriptor.valueOf(targetType));
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (this.conversionService != null) {
            try {
                return this.conversionService.convert(source, sourceType, targetType);
            }
            catch (ConversionFailedException conversionFailedException) {
                // empty catch block
            }
        }
        return this.additionalConverters.convert(source, sourceType, targetType);
    }

    private static class StringToEnumIgnoringCaseConverterFactory
    implements ConverterFactory<String, Enum> {
        private StringToEnumIgnoringCaseConverterFactory() {
        }

        public <T extends Enum> Converter<String, T> getConverter(Class<T> targetType) {
            Class<T> enumType;
            for (enumType = targetType; enumType != null && !enumType.isEnum(); enumType = enumType.getSuperclass()) {
            }
            Assert.notNull(enumType, (String)("The target type " + targetType.getName() + " does not refer to an enum"));
            return new StringToEnum<T>(enumType);
        }

        private class StringToEnum<T extends Enum>
        implements Converter<String, T> {
            private final Class<T> enumType;

            StringToEnum(Class<T> enumType) {
                this.enumType = enumType;
            }

            public T convert(String source) {
                if (source.isEmpty()) {
                    return null;
                }
                source = source.trim();
                for (Enum candidate : EnumSet.allOf(this.enumType)) {
                    RelaxedNames names = new RelaxedNames(candidate.name().replace('_', '-').toLowerCase(Locale.ENGLISH));
                    for (String name : names) {
                        if (!name.equals(source)) continue;
                        return (T)candidate;
                    }
                    if (!candidate.name().equalsIgnoreCase(source)) continue;
                    return (T)candidate;
                }
                throw new IllegalArgumentException("No enum constant " + this.enumType.getCanonicalName() + "." + source);
            }
        }
    }
}

