/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.ConfigurationPropertySourcesPropertySource;
import org.springframework.boot.context.properties.source.SpringConfigurationPropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class SpringConfigurationPropertySources
implements Iterable<ConfigurationPropertySource> {
    private final MutablePropertySources sources;
    private volatile PropertySourcesKey lastKey;
    private volatile List<ConfigurationPropertySource> adaptedSources;

    SpringConfigurationPropertySources(MutablePropertySources sources) {
        Assert.notNull((Object)sources, (String)"Sources must not be null");
        this.sources = sources;
    }

    @Override
    public Iterator<ConfigurationPropertySource> iterator() {
        this.checkForChanges();
        return this.adaptedSources.iterator();
    }

    private void checkForChanges() {
        PropertySourcesKey currentKey = new PropertySourcesKey(this.sources);
        PropertySourcesKey lastKey = this.lastKey;
        if (!currentKey.equals(lastKey)) {
            this.onChange(this.sources);
            this.lastKey = currentKey;
        }
    }

    private void onChange(MutablePropertySources sources) {
        this.adaptedSources = this.streamPropertySources((Iterable<PropertySource<?>>)sources).map(SpringConfigurationPropertySource::from).collect(Collectors.toList());
    }

    private Stream<PropertySource<?>> streamPropertySources(Iterable<PropertySource<?>> sources) {
        return StreamSupport.stream(sources.spliterator(), false).flatMap(this::flatten).filter(this::isIncluded);
    }

    private Stream<PropertySource<?>> flatten(PropertySource<?> source) {
        if (source.getSource() instanceof ConfigurableEnvironment) {
            return this.streamPropertySources((Iterable<PropertySource<?>>)((ConfigurableEnvironment)source.getSource()).getPropertySources());
        }
        return Stream.of(source);
    }

    private boolean isIncluded(PropertySource<?> source) {
        return !(source instanceof PropertySource.StubPropertySource) && !(source instanceof ConfigurationPropertySourcesPropertySource);
    }

    private static class PropertySourceKey {
        private final String name;
        private final Class<?> type;

        PropertySourceKey(PropertySource<?> source) {
            this.name = source.getName();
            this.type = source.getClass();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.name);
            result = 31 * result + ObjectUtils.nullSafeHashCode(this.type);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PropertySourceKey other = (PropertySourceKey)obj;
            boolean result = true;
            result = result && ObjectUtils.nullSafeEquals((Object)this.name, (Object)other.name);
            result = result && ObjectUtils.nullSafeEquals(this.type, other.type);
            return result;
        }
    }

    private static class PropertySourcesKey {
        private final List<PropertySourceKey> keys = new ArrayList<PropertySourceKey>();

        PropertySourcesKey(MutablePropertySources sources) {
            sources.forEach(this::addKey);
        }

        private void addKey(PropertySource<?> source) {
            this.keys.add(new PropertySourceKey(source));
        }

        public int hashCode() {
            return this.keys.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.keys.equals(((PropertySourcesKey)obj).keys);
        }
    }
}

