/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesBeanDefinitionRegistrar;
import org.springframework.boot.context.properties.ConfigurationPropertiesScan;
import org.springframework.boot.context.properties.InvalidConfigurationPropertiesException;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class ConfigurationPropertiesScanRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware,
ResourceLoaderAware {
    private Environment environment;
    private ResourceLoader resourceLoader;

    ConfigurationPropertiesScanRegistrar() {
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Set<String> packagesToScan = this.getPackagesToScan(importingClassMetadata);
        this.register(registry, (ConfigurableListableBeanFactory)registry, packagesToScan);
    }

    private Set<String> getPackagesToScan(AnnotationMetadata metadata) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(ConfigurationPropertiesScan.class.getName()));
        String[] basePackages = attributes.getStringArray("basePackages");
        Class[] basePackageClasses = attributes.getClassArray("basePackageClasses");
        LinkedHashSet<String> packagesToScan = new LinkedHashSet<String>(Arrays.asList(basePackages));
        for (Class basePackageClass : basePackageClasses) {
            packagesToScan.add(ClassUtils.getPackageName((Class)basePackageClass));
        }
        if (packagesToScan.isEmpty()) {
            packagesToScan.add(ClassUtils.getPackageName((String)metadata.getClassName()));
        }
        return packagesToScan;
    }

    protected void register(BeanDefinitionRegistry registry, ConfigurableListableBeanFactory beanFactory, Set<String> packagesToScan) {
        this.scan(packagesToScan, beanFactory, registry);
    }

    protected void scan(Set<String> packages, ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry) {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.setEnvironment(this.environment);
        scanner.setResourceLoader(this.resourceLoader);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(ConfigurationProperties.class));
        for (String basePackage : packages) {
            if (!StringUtils.hasText((String)basePackage)) continue;
            this.scan(beanFactory, registry, scanner, basePackage);
        }
    }

    private void scan(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry, ClassPathScanningCandidateComponentProvider scanner, String basePackage) throws LinkageError {
        for (BeanDefinition candidate : scanner.findCandidateComponents(basePackage)) {
            String beanClassName = candidate.getBeanClassName();
            try {
                Class type = ClassUtils.forName((String)beanClassName, null);
                this.validateScanConfiguration(type);
                ConfigurationPropertiesBeanDefinitionRegistrar.register(registry, beanFactory, type);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
    }

    private void validateScanConfiguration(Class<?> type) {
        MergedAnnotation component = MergedAnnotations.from(type, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.EXHAUSTIVE).get(Component.class);
        if (component.isPresent()) {
            throw new InvalidConfigurationPropertiesException(type, component.getRoot().getType());
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

