/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Consumer;
import org.springframework.aot.generate.ClassNameGenerator;
import org.springframework.aot.generate.DefaultGenerationContext;
import org.springframework.aot.generate.FileSystemGeneratedFiles;
import org.springframework.aot.generate.GeneratedFiles;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.ExecutableHint;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.aot.nativex.FileNativeConfigurationWriter;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationHooks;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.aot.ApplicationContextAotGenerator;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.javapoet.ClassName;
import org.springframework.util.Assert;
import org.springframework.util.FileSystemUtils;

public class AotProcessor {
    private static final Consumer<ExecutableHint.Builder> INVOKE_CONSTRUCTOR_HINT = hint -> hint.setModes(new ExecutableMode[]{ExecutableMode.INVOKE});
    private final Class<?> application;
    private final String[] applicationArgs;
    private final Path sourceOutput;
    private final Path resourceOutput;
    private final Path classOutput;
    private final String groupId;
    private final String artifactId;

    public AotProcessor(Class<?> application, String[] applicationArgs, Path sourceOutput, Path resourceOutput, Path classOutput, String groupId, String artifactId) {
        this.application = application;
        this.applicationArgs = applicationArgs;
        this.sourceOutput = sourceOutput;
        this.resourceOutput = resourceOutput;
        this.classOutput = classOutput;
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    public void process() {
        this.deleteExistingOutput();
        AotProcessorHook hook = new AotProcessorHook();
        SpringApplicationHooks.withHook((SpringApplicationHooks.Hook)hook, this::callApplicationMainMethod);
        GenericApplicationContext applicationContext = hook.getApplicationContext();
        Assert.notNull((Object)applicationContext, (String)("No application context available after calling main method of '" + this.application.getName() + "'. Does it run a SpringApplication?"));
        this.performAotProcessing(applicationContext);
    }

    private void deleteExistingOutput() {
        this.deleteExistingOutput(this.sourceOutput, this.resourceOutput, this.classOutput);
    }

    private void deleteExistingOutput(Path ... paths) {
        for (Path path : paths) {
            try {
                FileSystemUtils.deleteRecursively((Path)path);
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to delete existing output in '" + path + "'");
            }
        }
    }

    private void callApplicationMainMethod() {
        try {
            this.application.getMethod("main", String[].class).invoke(null, new Object[]{this.applicationArgs});
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            if (!(targetException instanceof MainMethodSilentExitException)) {
                RuntimeException runtimeEx;
                throw targetException instanceof RuntimeException ? (runtimeEx = (RuntimeException)targetException) : new RuntimeException(targetException);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void performAotProcessing(GenericApplicationContext applicationContext) {
        FileSystemGeneratedFiles generatedFiles = new FileSystemGeneratedFiles(this::getRoot);
        DefaultGenerationContext generationContext = new DefaultGenerationContext(new ClassNameGenerator(this.application), (GeneratedFiles)generatedFiles);
        ApplicationContextAotGenerator generator = new ApplicationContextAotGenerator();
        ClassName generatedInitializerClassName = generator.generateApplicationContext(applicationContext, (GenerationContext)generationContext);
        this.registerEntryPointHint(generationContext, generatedInitializerClassName);
        generationContext.writeGeneratedContent();
        this.writeHints(generationContext.getRuntimeHints());
        this.writeNativeImageProperties();
    }

    private void registerEntryPointHint(DefaultGenerationContext generationContext, ClassName generatedInitializerClassName) {
        TypeReference generatedType = TypeReference.of((String)generatedInitializerClassName.canonicalName());
        TypeReference applicationType = TypeReference.of(this.application);
        ReflectionHints reflection = generationContext.getRuntimeHints().reflection();
        reflection.registerType(applicationType, hint -> {});
        reflection.registerType(generatedType, hint -> hint.onReachableType(applicationType).withConstructor(Collections.emptyList(), INVOKE_CONSTRUCTOR_HINT));
    }

    private Path getRoot(GeneratedFiles.Kind kind) {
        return switch (kind) {
            default -> throw new IncompatibleClassChangeError();
            case GeneratedFiles.Kind.SOURCE -> this.sourceOutput;
            case GeneratedFiles.Kind.RESOURCE -> this.resourceOutput;
            case GeneratedFiles.Kind.CLASS -> this.classOutput;
        };
    }

    private void writeHints(RuntimeHints hints) {
        FileNativeConfigurationWriter writer = new FileNativeConfigurationWriter(this.resourceOutput, this.groupId, this.artifactId);
        writer.write(hints);
    }

    private void writeNativeImageProperties() {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add("-H:Class=" + this.application.getName());
        args.add("--report-unsupported-elements-at-runtime");
        args.add("--no-fallback");
        args.add("--install-exit-handlers");
        StringBuilder sb = new StringBuilder();
        sb.append("Args = ");
        sb.append(String.join((CharSequence)String.format(" \\%n", new Object[0]), args));
        Path file = this.resourceOutput.resolve("META-INF/native-image/" + this.groupId + "/" + this.artifactId + "/native-image.properties");
        try {
            if (!Files.exists(file, new LinkOption[0])) {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                Files.createFile(file, new FileAttribute[0]);
            }
            Files.writeString(file, (CharSequence)sb.toString(), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to write native-image properties", ex);
        }
    }

    public static void main(String[] args) throws Exception {
        int requiredArgs = 6;
        Assert.isTrue((args.length >= requiredArgs ? 1 : 0) != 0, () -> "Usage: " + AotProcessor.class.getName() + " <applicationName> <sourceOutput> <resourceOutput> <classOutput> <groupId> <artifactId> <originalArgs...>");
        String applicationName = args[0];
        Path sourceOutput = Paths.get(args[1], new String[0]);
        Path resourceOutput = Paths.get(args[2], new String[0]);
        Path classOutput = Paths.get(args[3], new String[0]);
        String groupId = args[4];
        String artifactId = args[5];
        String[] applicationArgs = args.length > requiredArgs ? Arrays.copyOfRange(args, requiredArgs, args.length) : new String[]{};
        Class<?> application = Class.forName(applicationName);
        new AotProcessor(application, applicationArgs, sourceOutput, resourceOutput, classOutput, groupId, artifactId).process();
    }

    private static class AotProcessorHook
    implements SpringApplicationHooks.Hook {
        private GenericApplicationContext context;

        private AotProcessorHook() {
        }

        @Override
        public boolean preRefresh(SpringApplication application, ConfigurableApplicationContext context) {
            Assert.isInstanceOf(GenericApplicationContext.class, (Object)context, () -> "AOT processing requires a GenericApplicationContext but got a " + context.getClass().getName());
            this.context = (GenericApplicationContext)context;
            return false;
        }

        @Override
        public void postRun(SpringApplication application, ConfigurableApplicationContext context) {
            throw new MainMethodSilentExitException();
        }

        GenericApplicationContext getApplicationContext() {
            return this.context;
        }
    }

    private static class MainMethodSilentExitException
    extends RuntimeException {
        private MainMethodSilentExitException() {
        }
    }
}

