/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.function.ThrowingSupplier;

final class SpringApplicationHooks {
    private static final ThreadLocal<Hooks> hooks = ThreadLocal.withInitial(Hooks::new);

    private SpringApplicationHooks() {
    }

    static <T> T withHook(Hook hook, ThrowingSupplier<T> action) throws Exception {
        hooks.get().add(hook);
        try {
            Object object = action.getWithException();
            return (T)object;
        }
        finally {
            hooks.get().remove(hook);
        }
    }

    static void withHook(Hook hook, Runnable action) {
        hooks.get().add(hook);
        try {
            action.run();
        }
        finally {
            hooks.get().remove(hook);
        }
    }

    static Hooks hooks() {
        return hooks.get();
    }

    static final class Hooks
    implements Hook {
        private final List<Hook> delegates = new ArrayList<Hook>();

        Hooks() {
        }

        private void add(Hook hook) {
            this.delegates.add(hook);
        }

        private void remove(Hook hook) {
            this.delegates.remove(hook);
        }

        @Override
        public void preRun(SpringApplication application) {
            for (Hook delegate : this.delegates) {
                delegate.preRun(application);
            }
        }

        @Override
        public void postRun(SpringApplication application, ConfigurableApplicationContext context) {
            for (Hook delegate : this.delegates) {
                delegate.postRun(application, context);
            }
        }

        @Override
        public boolean preRefresh(SpringApplication application, ConfigurableApplicationContext context) {
            for (Hook delegate : this.delegates) {
                if (delegate.preRefresh(application, context)) continue;
                return false;
            }
            return true;
        }
    }

    static interface Hook {
        default public void preRun(SpringApplication application) {
        }

        default public void postRun(SpringApplication application, ConfigurableApplicationContext context) {
        }

        default public boolean preRefresh(SpringApplication application, ConfigurableApplicationContext context) {
            return true;
        }
    }
}

