/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.beans.BeanInfoFactory;
import org.springframework.beans.ExtendedBeanInfoFactory;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindConstructorProvider;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.ReflectionUtils;

public final class ConfigurationPropertiesReflectionHintsProcessor {
    private static final BeanInfoFactory beanInfoFactory = new ExtendedBeanInfoFactory();
    private final Class<?> type;
    private final Constructor<?> bindConstructor;
    private final BeanInfo beanInfo;
    private final Set<Class<?>> seen;

    private ConfigurationPropertiesReflectionHintsProcessor(Class<?> type, Constructor<?> bindConstructor, Set<Class<?>> seen) {
        this.type = type;
        this.bindConstructor = bindConstructor;
        this.beanInfo = ConfigurationPropertiesReflectionHintsProcessor.getBeanInfo(type);
        this.seen = seen;
    }

    public static void processConfigurationProperties(Class<?> type, ReflectionHints reflectionHints) {
        new ConfigurationPropertiesReflectionHintsProcessor(type, ConfigurationPropertiesReflectionHintsProcessor.getBindConstructor(type, false), new HashSet()).process(reflectionHints);
    }

    private void processNestedType(Class<?> type, ReflectionHints reflectionHints) {
        this.processNestedType(type, ConfigurationPropertiesReflectionHintsProcessor.getBindConstructor(type, true), reflectionHints);
    }

    private void processNestedType(Class<?> type, Constructor<?> bindConstructor, ReflectionHints reflectionHints) {
        new ConfigurationPropertiesReflectionHintsProcessor(type, bindConstructor, this.seen).process(reflectionHints);
    }

    private static Constructor<?> getBindConstructor(Class<?> type, boolean nestedType) {
        Bindable<?> bindable = Bindable.of(type);
        return ConfigurationPropertiesBindConstructorProvider.INSTANCE.getBindConstructor(bindable, nestedType);
    }

    private void process(ReflectionHints reflectionHints) {
        if (this.seen.contains(this.type)) {
            return;
        }
        this.seen.add(this.type);
        reflectionHints.registerType(this.type, hint -> hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_PUBLIC_METHODS}));
        this.handleConstructor(reflectionHints);
        if (this.bindConstructor != null) {
            this.handleValueObjectProperties(reflectionHints);
        } else if (this.beanInfo != null) {
            this.handleJavaBeanProperties(reflectionHints);
        }
    }

    private void handleConstructor(ReflectionHints reflectionHints) {
        if (this.bindConstructor != null) {
            reflectionHints.registerConstructor(this.bindConstructor);
        } else {
            Arrays.stream(this.type.getDeclaredConstructors()).filter(candidate -> candidate.getParameterCount() == 0).findFirst().ifPresent(arg_0 -> ((ReflectionHints)reflectionHints).registerConstructor(arg_0));
        }
    }

    private void handleValueObjectProperties(ReflectionHints reflectionHints) {
        for (int i = 0; i < this.bindConstructor.getParameterCount(); ++i) {
            String propertyName = this.bindConstructor.getParameters()[i].getName();
            ResolvableType propertyType = ResolvableType.forConstructorParameter(this.bindConstructor, (int)i);
            this.handleProperty(reflectionHints, propertyName, propertyType);
        }
    }

    private void handleJavaBeanProperties(ReflectionHints reflectionHints) {
        for (PropertyDescriptor propertyDescriptor : this.beanInfo.getPropertyDescriptors()) {
            Method readMethod = propertyDescriptor.getReadMethod();
            if (readMethod == null) continue;
            ResolvableType propertyType = ResolvableType.forMethodReturnType((Method)readMethod, this.type);
            String propertyName = propertyDescriptor.getName();
            if (this.isSetterMandatory(propertyName, propertyType) && propertyDescriptor.getWriteMethod() == null) continue;
            this.handleProperty(reflectionHints, propertyName, propertyType);
        }
    }

    private void handleProperty(ReflectionHints reflectionHints, String propertyName, ResolvableType propertyType) {
        Class propertyClass = propertyType.resolve();
        if (propertyClass == null) {
            return;
        }
        if (propertyClass.equals(this.type)) {
            return;
        }
        Class<?> componentType = this.getComponentType(propertyType);
        if (componentType != null) {
            if (!this.isJavaType(componentType)) {
                this.processNestedType(componentType, reflectionHints);
            }
        } else if (this.isNestedType(propertyName, propertyClass)) {
            this.processNestedType(propertyClass, reflectionHints);
        }
    }

    private boolean isSetterMandatory(String propertyName, ResolvableType propertyType) {
        Class propertyClass = propertyType.resolve();
        if (propertyClass == null) {
            return true;
        }
        if (this.getComponentType(propertyType) != null) {
            return false;
        }
        return !this.isNestedType(propertyName, propertyClass);
    }

    private Class<?> getComponentType(ResolvableType propertyType) {
        Class propertyClass = propertyType.toClass();
        if (propertyType.isArray()) {
            return propertyType.getComponentType().toClass();
        }
        if (Collection.class.isAssignableFrom(propertyClass)) {
            return propertyType.as(Collection.class).getGeneric(new int[]{0}).toClass();
        }
        if (Map.class.isAssignableFrom(propertyClass)) {
            return propertyType.as(Map.class).getGeneric(new int[]{1}).toClass();
        }
        return null;
    }

    private boolean isNestedType(String propertyName, Class<?> propertyType) {
        if (this.type.equals(propertyType.getDeclaringClass())) {
            return true;
        }
        Field field = ReflectionUtils.findField(this.type, (String)propertyName);
        return field != null && MergedAnnotations.from((AnnotatedElement)field).isPresent(NestedConfigurationProperty.class);
    }

    private boolean isJavaType(Class<?> candidate) {
        return candidate.getPackageName().startsWith("java.");
    }

    private static BeanInfo getBeanInfo(Class<?> beanType) {
        try {
            BeanInfo beanInfo = beanInfoFactory.getBeanInfo(beanType);
            if (beanInfo != null) {
                return beanInfo;
            }
            return Introspector.getBeanInfo(beanType, 3);
        }
        catch (IntrospectionException ex) {
            return null;
        }
    }
}

