/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.log4j2;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerContextAware;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.springframework.boot.logging.log4j2.Log4J2LoggingSystem;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

@Plugin(name="spring", category="Lookup")
class SpringEnvironmentLookup
implements LoggerContextAware,
StrLookup {
    private volatile Environment environment;

    SpringEnvironmentLookup() {
    }

    public String lookup(LogEvent event, String key) {
        return this.lookup(key);
    }

    public String lookup(String key) {
        Assert.state((this.environment != null ? 1 : 0) != 0, (String)"Unable to obtain Spring Environment from LoggerContext");
        return this.environment != null ? this.environment.getProperty(key) : null;
    }

    public void setLoggerContext(LoggerContext loggerContext) {
        this.environment = Log4J2LoggingSystem.getEnvironment(loggerContext);
    }
}

