/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.client;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeHint;
import org.springframework.aot.hint.TypeReference;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.ClassUtils;

public class ClientHttpRequestFactorySupplier
implements Supplier<ClientHttpRequestFactory> {
    private static final String APACHE_HTTP_CLIENT_CLASS = "org.apache.hc.client5.http.impl.classic.HttpClients";
    private static final boolean APACHE_HTTP_CLIENT_PRESENT = ClassUtils.isPresent((String)"org.apache.hc.client5.http.impl.classic.HttpClients", null);
    private static final String OKHTTP_CLIENT_CLASS = "okhttp3.OkHttpClient";
    private static final boolean OKHTTP_CLIENT_PRESENT = ClassUtils.isPresent((String)"okhttp3.OkHttpClient", null);

    @Override
    public ClientHttpRequestFactory get() {
        if (APACHE_HTTP_CLIENT_PRESENT) {
            return new HttpComponentsClientHttpRequestFactory();
        }
        if (OKHTTP_CLIENT_PRESENT) {
            return new OkHttp3ClientHttpRequestFactory();
        }
        return new SimpleClientHttpRequestFactory();
    }

    static class ClientHttpRequestFactorySupplierRuntimeHints {
        ClientHttpRequestFactorySupplierRuntimeHints() {
        }

        static void registerHints(RuntimeHints hints, ClassLoader classLoader, Consumer<TypeHint.Builder> callback) {
            if (ClassUtils.isPresent((String)ClientHttpRequestFactorySupplier.APACHE_HTTP_CLIENT_CLASS, (ClassLoader)classLoader)) {
                hints.reflection().registerType(HttpComponentsClientHttpRequestFactory.class, typeHint -> callback.accept(typeHint.onReachableType(TypeReference.of((String)ClientHttpRequestFactorySupplier.APACHE_HTTP_CLIENT_CLASS))));
            }
            if (ClassUtils.isPresent((String)ClientHttpRequestFactorySupplier.OKHTTP_CLIENT_CLASS, (ClassLoader)classLoader)) {
                hints.reflection().registerType(OkHttp3ClientHttpRequestFactory.class, typeHint -> callback.accept(typeHint.onReachableType(TypeReference.of((String)ClientHttpRequestFactorySupplier.OKHTTP_CLIENT_CLASS))));
            }
            hints.reflection().registerType(SimpleClientHttpRequestFactory.class, typeHint -> callback.accept(typeHint.onReachableType(TypeReference.of(SimpleClientHttpRequestFactory.class))));
        }
    }
}

