/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.dubbo.client.loadbalancer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.dubbo.rpc.service.GenericException;
import org.springframework.cloud.alibaba.dubbo.client.loadbalancer.DubboHttpOutputMessage;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;

class DubboClientHttpResponse
implements ClientHttpResponse {
    private final HttpStatus httpStatus;
    private final String statusText;
    private final HttpHeaders httpHeaders = new HttpHeaders();
    private final DubboHttpOutputMessage httpOutputMessage;

    public DubboClientHttpResponse(DubboHttpOutputMessage httpOutputMessage, GenericException exception) {
        this.httpStatus = exception != null ? HttpStatus.INTERNAL_SERVER_ERROR : HttpStatus.OK;
        this.statusText = exception != null ? exception.getExceptionMessage() : this.httpStatus.getReasonPhrase();
        this.httpOutputMessage = httpOutputMessage;
        this.httpHeaders.putAll((Map)httpOutputMessage.getHeaders());
    }

    public HttpStatus getStatusCode() throws IOException {
        return this.httpStatus;
    }

    public int getRawStatusCode() throws IOException {
        return this.httpStatus.value();
    }

    public String getStatusText() throws IOException {
        return this.statusText;
    }

    public void close() {
    }

    public InputStream getBody() throws IOException {
        return this.httpOutputMessage.getBody().getInputStream();
    }

    public HttpHeaders getHeaders() {
        return this.httpHeaders;
    }
}

