/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.dubbo.registry;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.support.FailbackRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.alibaba.dubbo.metadata.repository.DubboServiceMetadataRepository;
import org.springframework.cloud.alibaba.dubbo.service.DubboMetadataService;
import org.springframework.cloud.alibaba.dubbo.service.DubboMetadataServiceProxy;
import org.springframework.cloud.alibaba.dubbo.util.JSONUtils;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.util.StringUtils;

public abstract class AbstractSpringCloudRegistry
extends FailbackRegistry {
    public static final String SERVICES_LOOKUP_INTERVAL_PARAM_NAME = "dubbo.services.lookup.interval";
    protected static final String DUBBO_METADATA_SERVICE_CLASS_NAME = DubboMetadataService.class.getName();
    private static final Set<String> schedulerTasks = new HashSet<String>();
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final long servicesLookupInterval;
    private final DiscoveryClient discoveryClient;
    private final DubboServiceMetadataRepository repository;
    private final DubboMetadataServiceProxy dubboMetadataConfigServiceProxy;
    private final JSONUtils jsonUtils;
    protected final ScheduledExecutorService servicesLookupScheduler;

    public AbstractSpringCloudRegistry(URL url, DiscoveryClient discoveryClient, DubboServiceMetadataRepository dubboServiceMetadataRepository, DubboMetadataServiceProxy dubboMetadataConfigServiceProxy, JSONUtils jsonUtils, ScheduledExecutorService servicesLookupScheduler) {
        super(url);
        this.servicesLookupInterval = url.getParameter(SERVICES_LOOKUP_INTERVAL_PARAM_NAME, 60L);
        this.discoveryClient = discoveryClient;
        this.repository = dubboServiceMetadataRepository;
        this.dubboMetadataConfigServiceProxy = dubboMetadataConfigServiceProxy;
        this.jsonUtils = jsonUtils;
        this.servicesLookupScheduler = servicesLookupScheduler;
    }

    protected boolean shouldRegister(URL url) {
        String side = url.getParameter("side");
        boolean should = "provider".equals(side);
        if (!should && this.logger.isDebugEnabled()) {
            this.logger.debug("The URL[{}] should not be registered.", (Object)url.toString());
        }
        return should;
    }

    public final void doRegister(URL url) {
        if (!this.shouldRegister(url)) {
            return;
        }
        this.doRegister0(url);
    }

    protected abstract void doRegister0(URL var1);

    public final void doUnregister(URL url) {
        if (!this.shouldRegister(url)) {
            return;
        }
        this.doUnregister0(url);
    }

    protected abstract void doUnregister0(URL var1);

    public final void doSubscribe(URL url, NotifyListener listener) {
        if (!this.isAdminURL(url)) {
            if (this.isDubboMetadataServiceURL(url)) {
                this.subscribeDubboMetadataServiceURLs(url, listener);
            } else {
                this.subscribeDubboServiceURLs(url, listener);
            }
        }
    }

    protected void subscribeDubboServiceURLs(URL url, NotifyListener listener) {
        this.doSubscribeDubboServiceURLs(url, listener);
        this.submitSchedulerTaskIfAbsent(url, listener);
    }

    private void submitSchedulerTaskIfAbsent(URL url, NotifyListener listener) {
        String taskId = url.toIdentityString();
        if (schedulerTasks.add(taskId)) {
            this.schedule(() -> this.doSubscribeDubboServiceURLs(url, listener));
        }
    }

    protected void doSubscribeDubboServiceURLs(URL url, NotifyListener listener) {
        Set<String> subscribedServices = this.repository.getSubscribedServices();
        subscribedServices.stream().map(this.dubboMetadataConfigServiceProxy::getProxy).filter(Objects::nonNull).forEach(dubboMetadataService -> {
            List<URL> exportedURLs = this.getExportedURLs((DubboMetadataService)dubboMetadataService, url);
            LinkedList allSubscribedURLs = new LinkedList();
            for (URL exportedURL : exportedURLs) {
                String serviceName = exportedURL.getParameter("application");
                List<ServiceInstance> serviceInstances = this.getServiceInstances(serviceName);
                String protocol = exportedURL.getProtocol();
                LinkedList subscribedURLs = new LinkedList();
                serviceInstances.forEach(serviceInstance -> {
                    Integer port = this.repository.getDubboProtocolPort((ServiceInstance)serviceInstance, protocol);
                    String host = serviceInstance.getHost();
                    if (port == null) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("The protocol[{}] port of Dubbo  service instance[host : {}] can't be resolved", (Object)protocol, (Object)host);
                        }
                    } else {
                        URL subscribedURL = new URL(protocol, host, port.intValue(), exportedURL.getParameters());
                        subscribedURLs.add(subscribedURL);
                    }
                });
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("The subscribed URL[{}] will notify all URLs : {}", (Object)url, subscribedURLs);
                }
                allSubscribedURLs.addAll(subscribedURLs);
            }
            listener.notify(allSubscribedURLs);
        });
    }

    private List<ServiceInstance> getServiceInstances(String serviceName) {
        return StringUtils.hasText((String)serviceName) ? this.doGetServiceInstances(serviceName) : Collections.emptyList();
    }

    private List<ServiceInstance> doGetServiceInstances(String serviceName) {
        List serviceInstances;
        block2: {
            serviceInstances = Collections.emptyList();
            try {
                serviceInstances = this.discoveryClient.getInstances(serviceName);
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return serviceInstances;
    }

    private List<URL> getExportedURLs(DubboMetadataService dubboMetadataService, URL url) {
        String serviceInterface = url.getServiceInterface();
        String group = url.getParameter("group");
        String version = url.getParameter("version");
        String subscribedProtocol = url.getParameter("protocol");
        String exportedURLsJSON = dubboMetadataService.getExportedURLs(serviceInterface, group, version);
        return this.jsonUtils.toURLs(exportedURLsJSON).stream().filter(exportedURL -> subscribedProtocol == null || subscribedProtocol.equalsIgnoreCase(exportedURL.getProtocol())).collect(Collectors.toList());
    }

    private void subscribeDubboMetadataServiceURLs(URL url, NotifyListener listener) {
        String serviceInterface = url.getServiceInterface();
        String group = url.getParameter("group");
        String version = url.getParameter("version");
        String protocol = url.getParameter("protocol");
        List<URL> urls = this.repository.findSubscribedDubboMetadataServiceURLs(serviceInterface, group, version, protocol);
        listener.notify(urls);
    }

    public final void doUnsubscribe(URL url, NotifyListener listener) {
        if (this.isAdminURL(url)) {
            this.shutdownServiceNamesLookup();
        }
    }

    public boolean isAvailable() {
        return !this.discoveryClient.getServices().isEmpty();
    }

    protected void shutdownServiceNamesLookup() {
        if (this.servicesLookupScheduler != null) {
            this.servicesLookupScheduler.shutdown();
        }
    }

    protected boolean isAdminURL(URL url) {
        return "admin".equals(url.getProtocol());
    }

    protected boolean isDubboMetadataServiceURL(URL url) {
        return DUBBO_METADATA_SERVICE_CLASS_NAME.equals(url.getServiceInterface());
    }

    protected ScheduledFuture<?> schedule(Runnable runnable) {
        return this.servicesLookupScheduler.scheduleAtFixedRate(runnable, this.servicesLookupInterval, this.servicesLookupInterval, TimeUnit.SECONDS);
    }
}

