/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.dubbo.service;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.cloud.alibaba.dubbo.service.DubboGenericServiceFactory;
import org.springframework.cloud.alibaba.dubbo.service.DubboMetadataService;
import org.springframework.cloud.alibaba.dubbo.service.DubboMetadataServiceInvocationHandler;

public class DubboMetadataServiceProxy
implements BeanClassLoaderAware,
DisposableBean {
    private final DubboGenericServiceFactory dubboGenericServiceFactory;
    private ClassLoader classLoader;
    private final Map<String, DubboMetadataService> dubboMetadataServiceCache = new ConcurrentHashMap<String, DubboMetadataService>();

    public DubboMetadataServiceProxy(DubboGenericServiceFactory dubboGenericServiceFactory) {
        this.dubboGenericServiceFactory = dubboGenericServiceFactory;
    }

    public DubboMetadataService initProxy(String serviceName, String version) {
        return this.dubboMetadataServiceCache.computeIfAbsent(serviceName, name -> this.newProxy((String)name, version));
    }

    public DubboMetadataService getProxy(String serviceName) {
        return this.dubboMetadataServiceCache.get(serviceName);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void destroy() throws Exception {
        this.dubboMetadataServiceCache.clear();
    }

    protected DubboMetadataService newProxy(String serviceName, String version) {
        return (DubboMetadataService)Proxy.newProxyInstance(this.classLoader, new Class[]{DubboMetadataService.class}, (InvocationHandler)new DubboMetadataServiceInvocationHandler(serviceName, version, this.dubboGenericServiceFactory));
    }
}

