/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.resilience4j;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadRegistry;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.micrometer.tagged.TaggedBulkheadMetrics;
import io.github.resilience4j.micrometer.tagged.TaggedCircuitBreakerMetrics;
import io.github.resilience4j.micrometer.tagged.TaggedThreadPoolBulkheadMetrics;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4JCircuitBreakerFactory;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4jBulkheadProvider;
import org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"spring.cloud.circuitbreaker.resilience4j.enabled", "spring.cloud.circuitbreaker.resilience4j.blocking.enabled"}, matchIfMissing=true)
public class Resilience4JAutoConfiguration {
    @Autowired(required=false)
    private List<Customizer<Resilience4JCircuitBreakerFactory>> customizers = new ArrayList<Customizer<Resilience4JCircuitBreakerFactory>>();

    @Bean
    @ConditionalOnMissingBean(value={CircuitBreakerFactory.class})
    public Resilience4JCircuitBreakerFactory resilience4jCircuitBreakerFactory(CircuitBreakerRegistry circuitBreakerRegistry, TimeLimiterRegistry timeLimiterRegistry, @Autowired(required=false) Resilience4jBulkheadProvider bulkheadProvider) {
        Resilience4JCircuitBreakerFactory factory = new Resilience4JCircuitBreakerFactory(circuitBreakerRegistry, timeLimiterRegistry, bulkheadProvider);
        this.customizers.forEach(customizer -> customizer.customize((Object)factory));
        return factory;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={MeterRegistry.class})
    @ConditionalOnClass(name={"io.github.resilience4j.micrometer.tagged.TaggedCircuitBreakerMetrics"})
    public static class MicrometerResilience4JCustomizerConfiguration {
        @Autowired(required=false)
        private Resilience4JCircuitBreakerFactory factory;
        @Autowired(required=false)
        private Resilience4jBulkheadProvider bulkheadProvider;
        @Autowired
        private MeterRegistry meterRegistry;

        @PostConstruct
        public void init() {
            if (this.factory != null) {
                TaggedCircuitBreakerMetrics.ofCircuitBreakerRegistry((CircuitBreakerRegistry)this.factory.getCircuitBreakerRegistry()).bindTo(this.meterRegistry);
            }
            if (this.bulkheadProvider != null) {
                TaggedBulkheadMetrics.ofBulkheadRegistry((BulkheadRegistry)this.bulkheadProvider.getBulkheadRegistry()).bindTo(this.meterRegistry);
                TaggedThreadPoolBulkheadMetrics.ofThreadPoolBulkheadRegistry((ThreadPoolBulkheadRegistry)this.bulkheadProvider.getThreadPoolBulkheadRegistry()).bindTo(this.meterRegistry);
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Bulkhead.class})
    @ConditionalOnProperty(value={"spring.cloud.circuitbreaker.bulkhead.resilience4j.enabled"}, matchIfMissing=true)
    public static class Resilience4jBulkheadConfiguration {
        @Autowired(required=false)
        private List<Customizer<Resilience4jBulkheadProvider>> bulkheadCustomizers = new ArrayList<Customizer<Resilience4jBulkheadProvider>>();

        @Bean
        public Resilience4jBulkheadProvider bulkheadProvider(ThreadPoolBulkheadRegistry threadPoolBulkheadRegistry, BulkheadRegistry bulkheadRegistry) {
            Resilience4jBulkheadProvider resilience4jBulkheadProvider = new Resilience4jBulkheadProvider(threadPoolBulkheadRegistry, bulkheadRegistry);
            this.bulkheadCustomizers.forEach(customizer -> customizer.customize((Object)resilience4jBulkheadProvider));
            return resilience4jBulkheadProvider;
        }
    }
}

