/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.cloud.client.loadbalancer.RetryableStatusCodeException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.AbstractClientHttpResponse;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;

public class ClientHttpResponseStatusCodeException
extends RetryableStatusCodeException {
    private ClientHttpResponseWrapper response;

    public ClientHttpResponseStatusCodeException(String serviceId, ClientHttpResponse response) throws IOException {
        super(serviceId, response.getRawStatusCode(), response, null);
        this.response = new ClientHttpResponseWrapper(response);
        response.close();
    }

    public ClientHttpResponse getResponse() {
        return this.response;
    }

    static class ClientHttpResponseWrapper
    extends AbstractClientHttpResponse {
        private ClientHttpResponse response;
        private byte[] body;

        public ClientHttpResponseWrapper(ClientHttpResponse response) throws IOException {
            this.response = response;
            this.body = StreamUtils.copyToByteArray((InputStream)response.getBody());
        }

        public int getRawStatusCode() throws IOException {
            return this.response.getRawStatusCode();
        }

        public String getStatusText() throws IOException {
            return this.response.getStatusText();
        }

        public void close() {
            this.response.close();
        }

        public InputStream getBody() throws IOException {
            return new ByteArrayInputStream(this.body);
        }

        public HttpHeaders getHeaders() {
            return this.response.getHeaders();
        }
    }
}

