/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.Period;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="spring.cloud.consul.discovery.heartbeat")
@Validated
public class HeartbeatProperties {
    private static final Log log = LogFactory.getLog(HeartbeatProperties.class);
    boolean enabled = false;
    @Min(value=1L)
    private @Min(value=1L) int ttlValue = 30;
    @NotNull
    private String ttlUnit = "s";
    @DecimalMin(value="0.1")
    @DecimalMax(value="0.9")
    private @DecimalMin(value="0.1") @DecimalMax(value="0.9") double intervalRatio = 0.6666666666666666;

    protected Period computeHearbeatInterval() {
        double interval = (double)this.ttlValue * this.intervalRatio;
        double max = Math.max(interval, 1.0);
        int ttlMinus1 = this.ttlValue - 1;
        double min = Math.min((double)ttlMinus1, max);
        Period heartbeatInterval = new Period(Math.round(1000.0 * min));
        log.debug((Object)("Computed heartbeatInterval: " + heartbeatInterval));
        return heartbeatInterval;
    }

    public String getTtl() {
        return this.ttlValue + this.ttlUnit;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getTtlValue() {
        return this.ttlValue;
    }

    public String getTtlUnit() {
        return this.ttlUnit;
    }

    public double getIntervalRatio() {
        return this.intervalRatio;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setTtlValue(int ttlValue) {
        this.ttlValue = ttlValue;
    }

    public void setTtlUnit(String ttlUnit) {
        this.ttlUnit = ttlUnit;
    }

    public void setIntervalRatio(double intervalRatio) {
        this.intervalRatio = intervalRatio;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HeartbeatProperties)) {
            return false;
        }
        HeartbeatProperties other = (HeartbeatProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getTtlValue() != other.getTtlValue()) {
            return false;
        }
        String this$ttlUnit = this.getTtlUnit();
        String other$ttlUnit = other.getTtlUnit();
        if (this$ttlUnit == null ? other$ttlUnit != null : !this$ttlUnit.equals(other$ttlUnit)) {
            return false;
        }
        return Double.compare(this.getIntervalRatio(), other.getIntervalRatio()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof HeartbeatProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getTtlValue();
        String $ttlUnit = this.getTtlUnit();
        result = result * 59 + ($ttlUnit == null ? 43 : $ttlUnit.hashCode());
        long $intervalRatio = Double.doubleToLongBits(this.getIntervalRatio());
        result = result * 59 + (int)($intervalRatio >>> 32 ^ $intervalRatio);
        return result;
    }

    public String toString() {
        return "HeartbeatProperties(enabled=" + this.isEnabled() + ", ttlValue=" + this.getTtlValue() + ", ttlUnit=" + this.getTtlUnit() + ", intervalRatio=" + this.getIntervalRatio() + ")";
    }
}

