/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.commons.util.InetUtils;

@ConfigurationProperties(value="spring.cloud.consul.discovery")
public class ConsulDiscoveryProperties {
    protected static final String MANAGEMENT = "management";
    private InetUtils.HostInfo hostInfo;
    @Value(value="${consul.token:${CONSUL_TOKEN:${spring.cloud.consul.token:${SPRING_CLOUD_CONSUL_TOKEN:}}}}")
    private String aclToken;
    private List<String> tags = new ArrayList<String>();
    private boolean enabled = true;
    private List<String> managementTags = Arrays.asList("management");
    private String healthCheckPath = "/actuator/health";
    private String healthCheckUrl;
    private String healthCheckInterval = "10s";
    private String healthCheckTimeout;
    private String healthCheckCriticalTimeout;
    private String ipAddress;
    private String hostname;
    private Integer port;
    private Integer managementPort;
    private Lifecycle lifecycle = new Lifecycle();
    private boolean preferIpAddress = false;
    private boolean preferAgentAddress = false;
    private int catalogServicesWatchDelay = 10;
    private int catalogServicesWatchTimeout = 2;
    private String serviceName;
    private String instanceId;
    private String instanceZone;
    private String instanceGroup;
    private String defaultZoneMetadataName = "zone";
    private String scheme = "http";
    private String managementSuffix = "management";
    private Map<String, String> serverListQueryTags = new HashMap<String, String>();
    private Map<String, String> datacenters = new HashMap<String, String>();
    private String defaultQueryTag;
    private boolean queryPassing = false;
    private boolean register = true;
    private boolean deregister = true;
    private boolean registerHealthCheck = true;
    private boolean failFast = true;
    private Boolean healthCheckTlsSkipVerify;

    private ConsulDiscoveryProperties() {
    }

    public ConsulDiscoveryProperties(InetUtils inetUtils) {
        this.hostInfo = inetUtils.findFirstNonLoopbackHostInfo();
        this.ipAddress = this.hostInfo.getIpAddress();
        this.hostname = this.hostInfo.getHostname();
    }

    public String getQueryTagForService(String serviceId) {
        String tag = this.serverListQueryTags.get(serviceId);
        return tag != null ? tag : this.defaultQueryTag;
    }

    public String getHostname() {
        return this.preferIpAddress ? this.ipAddress : this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
        this.hostInfo.override = true;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        this.hostInfo.override = true;
    }

    private InetUtils.HostInfo getHostInfo() {
        return this.hostInfo;
    }

    private void setHostInfo(InetUtils.HostInfo hostInfo) {
        this.hostInfo = hostInfo;
    }

    public String getAclToken() {
        return this.aclToken;
    }

    public void setAclToken(String aclToken) {
        this.aclToken = aclToken;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<String> getManagementTags() {
        return this.managementTags;
    }

    public void setManagementTags(List<String> managementTags) {
        this.managementTags = managementTags;
    }

    public String getHealthCheckPath() {
        return this.healthCheckPath;
    }

    public void setHealthCheckPath(String healthCheckPath) {
        this.healthCheckPath = healthCheckPath;
    }

    public String getHealthCheckUrl() {
        return this.healthCheckUrl;
    }

    public void setHealthCheckUrl(String healthCheckUrl) {
        this.healthCheckUrl = healthCheckUrl;
    }

    public String getHealthCheckInterval() {
        return this.healthCheckInterval;
    }

    public void setHealthCheckInterval(String healthCheckInterval) {
        this.healthCheckInterval = healthCheckInterval;
    }

    public String getHealthCheckTimeout() {
        return this.healthCheckTimeout;
    }

    public void setHealthCheckTimeout(String healthCheckTimeout) {
        this.healthCheckTimeout = healthCheckTimeout;
    }

    public String getHealthCheckCriticalTimeout() {
        return this.healthCheckCriticalTimeout;
    }

    public void setHealthCheckCriticalTimeout(String healthCheckCriticalTimeout) {
        this.healthCheckCriticalTimeout = healthCheckCriticalTimeout;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getManagementPort() {
        return this.managementPort;
    }

    public void setManagementPort(Integer managementPort) {
        this.managementPort = managementPort;
    }

    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    public void setLifecycle(Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public boolean isPreferIpAddress() {
        return this.preferIpAddress;
    }

    public void setPreferIpAddress(boolean preferIpAddress) {
        this.preferIpAddress = preferIpAddress;
    }

    public boolean isPreferAgentAddress() {
        return this.preferAgentAddress;
    }

    public void setPreferAgentAddress(boolean preferAgentAddress) {
        this.preferAgentAddress = preferAgentAddress;
    }

    public int getCatalogServicesWatchDelay() {
        return this.catalogServicesWatchDelay;
    }

    public void setCatalogServicesWatchDelay(int catalogServicesWatchDelay) {
        this.catalogServicesWatchDelay = catalogServicesWatchDelay;
    }

    public int getCatalogServicesWatchTimeout() {
        return this.catalogServicesWatchTimeout;
    }

    public void setCatalogServicesWatchTimeout(int catalogServicesWatchTimeout) {
        this.catalogServicesWatchTimeout = catalogServicesWatchTimeout;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceZone() {
        return this.instanceZone;
    }

    public void setInstanceZone(String instanceZone) {
        this.instanceZone = instanceZone;
    }

    public String getInstanceGroup() {
        return this.instanceGroup;
    }

    public void setInstanceGroup(String instanceGroup) {
        this.instanceGroup = instanceGroup;
    }

    public String getDefaultZoneMetadataName() {
        return this.defaultZoneMetadataName;
    }

    public void setDefaultZoneMetadataName(String defaultZoneMetadataName) {
        this.defaultZoneMetadataName = defaultZoneMetadataName;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getManagementSuffix() {
        return this.managementSuffix;
    }

    public void setManagementSuffix(String managementSuffix) {
        this.managementSuffix = managementSuffix;
    }

    public Map<String, String> getServerListQueryTags() {
        return this.serverListQueryTags;
    }

    public void setServerListQueryTags(Map<String, String> serverListQueryTags) {
        this.serverListQueryTags = serverListQueryTags;
    }

    public Map<String, String> getDatacenters() {
        return this.datacenters;
    }

    public void setDatacenters(Map<String, String> datacenters) {
        this.datacenters = datacenters;
    }

    public String getDefaultQueryTag() {
        return this.defaultQueryTag;
    }

    public void setDefaultQueryTag(String defaultQueryTag) {
        this.defaultQueryTag = defaultQueryTag;
    }

    public boolean isQueryPassing() {
        return this.queryPassing;
    }

    public void setQueryPassing(boolean queryPassing) {
        this.queryPassing = queryPassing;
    }

    public boolean isRegister() {
        return this.register;
    }

    public void setRegister(boolean register) {
        this.register = register;
    }

    public boolean isDeregister() {
        return this.deregister;
    }

    public void setDeregister(boolean deregister) {
        this.deregister = deregister;
    }

    public boolean isRegisterHealthCheck() {
        return this.registerHealthCheck;
    }

    public void setRegisterHealthCheck(boolean registerHealthCheck) {
        this.registerHealthCheck = registerHealthCheck;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public Boolean getHealthCheckTlsSkipVerify() {
        return this.healthCheckTlsSkipVerify;
    }

    public void setHealthCheckTlsSkipVerify(Boolean healthCheckTlsSkipVerify) {
        this.healthCheckTlsSkipVerify = healthCheckTlsSkipVerify;
    }

    public String toString() {
        return "ConsulDiscoveryProperties{hostInfo=" + this.hostInfo + ", aclToken='" + this.aclToken + '\'' + ", tags=" + this.tags + ", enabled=" + this.enabled + ", managementTags=" + this.managementTags + ", healthCheckPath='" + this.healthCheckPath + '\'' + ", healthCheckUrl='" + this.healthCheckUrl + '\'' + ", healthCheckInterval='" + this.healthCheckInterval + '\'' + ", healthCheckTimeout='" + this.healthCheckTimeout + '\'' + ", healthCheckCriticalTimeout='" + this.healthCheckCriticalTimeout + '\'' + ", ipAddress='" + this.ipAddress + '\'' + ", hostname='" + this.hostname + '\'' + ", port=" + this.port + ", managementPort=" + this.managementPort + ", lifecycle=" + this.lifecycle + ", preferIpAddress=" + this.preferIpAddress + ", preferAgentAddress=" + this.preferAgentAddress + ", catalogServicesWatchDelay=" + this.catalogServicesWatchDelay + ", catalogServicesWatchTimeout=" + this.catalogServicesWatchTimeout + ", serviceName='" + this.serviceName + '\'' + ", instanceId='" + this.instanceId + '\'' + ", instanceZone='" + this.instanceZone + '\'' + ", instanceGroup='" + this.instanceGroup + '\'' + ", defaultZoneMetadataName='" + this.defaultZoneMetadataName + '\'' + ", scheme='" + this.scheme + '\'' + ", managementSuffix='" + this.managementSuffix + '\'' + ", serverListQueryTags=" + this.serverListQueryTags + ", datacenters=" + this.datacenters + ", defaultQueryTag='" + this.defaultQueryTag + '\'' + ", queryPassing=" + this.queryPassing + ", register=" + this.register + ", deregister=" + this.deregister + ", registerHealthCheck=" + this.registerHealthCheck + ", failFast=" + this.failFast + ", healthCheckTlsSkipVerify=" + this.healthCheckTlsSkipVerify + '}';
    }

    public static class Lifecycle {
        private boolean enabled = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String toString() {
            return "Lifecycle{enabled=" + this.enabled + '}';
        }
    }
}

