/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap.encrypt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.security.crypto.encrypt.TextEncryptor;

public abstract class AbstractEnvironmentDecrypt {
    private static final Pattern COLLECTION_PROPERTY = Pattern.compile("(\\S+)?\\[(\\d+)\\](\\.\\S+)?");
    public static final String DECRYPTED_PROPERTY_SOURCE_NAME = "decrypted";
    public static final String ENCRYPTED_PROPERTY_PREFIX = "{cipher}";
    protected Log logger = LogFactory.getLog(this.getClass());
    private boolean failOnError = true;

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    protected Map<String, Object> decrypt(TextEncryptor encryptor, PropertySources propertySources) {
        Map<String, Object> properties = this.merge(propertySources);
        this.decrypt(encryptor, properties);
        return properties;
    }

    protected Map<String, Object> merge(PropertySources propertySources) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        ArrayList<PropertySource> sources = new ArrayList<PropertySource>();
        for (PropertySource source : propertySources) {
            sources.add(0, source);
        }
        for (PropertySource source : sources) {
            this.merge(source, properties);
        }
        return properties;
    }

    protected void merge(PropertySource<?> source, Map<String, Object> properties) {
        if (source instanceof CompositePropertySource) {
            ArrayList sources = new ArrayList(((CompositePropertySource)source).getPropertySources());
            Collections.reverse(sources);
            for (PropertySource nested : sources) {
                this.merge(nested, properties);
            }
        } else if (source instanceof EnumerablePropertySource) {
            LinkedHashMap<String, String> otherCollectionProperties = new LinkedHashMap<String, String>();
            boolean sourceHasDecryptedCollection = false;
            EnumerablePropertySource enumerable = (EnumerablePropertySource)source;
            for (String key : enumerable.getPropertyNames()) {
                Object property = source.getProperty(key);
                if (property == null) continue;
                String value = property.toString();
                if (value.startsWith(ENCRYPTED_PROPERTY_PREFIX)) {
                    properties.put(key, value);
                    if (!COLLECTION_PROPERTY.matcher(key).matches()) continue;
                    sourceHasDecryptedCollection = true;
                    continue;
                }
                if (COLLECTION_PROPERTY.matcher(key).matches()) {
                    otherCollectionProperties.put(key, value);
                    continue;
                }
                properties.remove(key);
            }
            if (sourceHasDecryptedCollection && !otherCollectionProperties.isEmpty()) {
                properties.putAll(otherCollectionProperties);
            }
        }
    }

    protected void decrypt(TextEncryptor encryptor, Map<String, Object> properties) {
        properties.replaceAll((key, value) -> {
            String valueString = value.toString();
            if (!valueString.startsWith(ENCRYPTED_PROPERTY_PREFIX)) {
                return value;
            }
            return this.decrypt(encryptor, (String)key, valueString);
        });
    }

    protected String decrypt(TextEncryptor encryptor, String key, String original) {
        String value = original.substring(ENCRYPTED_PROPERTY_PREFIX.length());
        try {
            value = encryptor.decrypt(value);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Decrypted: key=" + key));
            }
            return value;
        }
        catch (Exception e) {
            String message = "Cannot decrypt: key=" + key;
            if (this.logger.isDebugEnabled()) {
                this.logger.warn((Object)message, (Throwable)e);
            } else {
                this.logger.warn((Object)message);
            }
            if (this.failOnError) {
                throw new IllegalStateException(message, e);
            }
            return "";
        }
    }
}

