/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.catalog;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.messaging.Message;
import org.springframework.util.StringUtils;

public abstract class FunctionAroundWrapper {
    private static final Log log = LogFactory.getLog(FunctionAroundWrapper.class);

    public final Object apply(Object input, SimpleFunctionRegistry.FunctionInvocationWrapper targetFunction) {
        boolean functionalTracingEnabled;
        String functionalTracingEnabledStr = System.getProperty("spring.cloud.function.observability.enabled");
        boolean bl = functionalTracingEnabled = StringUtils.hasText((String)functionalTracingEnabledStr) ? Boolean.parseBoolean(functionalTracingEnabledStr) : true;
        if (functionalTracingEnabled && !(input instanceof Publisher) && input instanceof Message && !FunctionTypeUtils.isCollectionOfMessage(targetFunction.getOutputType())) {
            return this.doApply(input, targetFunction);
        }
        return targetFunction.apply(input);
    }

    protected abstract Object doApply(Object var1, SimpleFunctionRegistry.FunctionInvocationWrapper var2);
}

