/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rocketmq.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.spring.autoconfigure.RocketMQAutoConfiguration;
import org.apache.rocketmq.spring.config.RocketMQTransactionAnnotationProcessor;
import org.apache.rocketmq.spring.config.TransactionHandlerRegistry;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@Configuration
@AutoConfigureAfter(value={RocketMQAutoConfiguration.class})
@ConditionalOnMissingBean(value={DefaultMQProducer.class})
public class RocketMQComponent4BinderAutoConfiguration {
    private final Environment environment;

    public RocketMQComponent4BinderAutoConfiguration(Environment environment) {
        this.environment = environment;
    }

    @Bean
    @ConditionalOnMissingBean(value={DefaultMQProducer.class})
    public DefaultMQProducer defaultMQProducer() {
        DefaultMQProducer producer;
        String configNameServer = this.environment.resolveRequiredPlaceholders("${spring.cloud.stream.rocketmq.binder.name-server:${rocketmq.producer.name-server:}}");
        String ak = this.environment.resolveRequiredPlaceholders("${spring.cloud.stream.rocketmq.binder.access-key:${rocketmq.producer.access-key:}}");
        String sk = this.environment.resolveRequiredPlaceholders("${spring.cloud.stream.rocketmq.binder.secret-key:${rocketmq.producer.secret-key:}}");
        if (!StringUtils.isEmpty((Object)ak) && !StringUtils.isEmpty((Object)sk)) {
            producer = new DefaultMQProducer("rocketmq_binder_default_group_name", (RPCHook)new AclClientRPCHook(new SessionCredentials(ak, sk)));
            producer.setVipChannelEnabled(false);
        } else {
            producer = new DefaultMQProducer("rocketmq_binder_default_group_name");
        }
        if (StringUtils.isEmpty((Object)configNameServer)) {
            configNameServer = "127.0.0.1:9876";
        }
        producer.setNamesrvAddr(configNameServer);
        return producer;
    }

    @Bean(destroyMethod="destroy")
    @ConditionalOnMissingBean
    public RocketMQTemplate rocketMQTemplate(DefaultMQProducer mqProducer, ObjectMapper objectMapper) {
        RocketMQTemplate rocketMQTemplate = new RocketMQTemplate();
        rocketMQTemplate.setProducer(mqProducer);
        rocketMQTemplate.setObjectMapper(objectMapper);
        return rocketMQTemplate;
    }

    @Bean
    @ConditionalOnBean(value={RocketMQTemplate.class})
    @ConditionalOnMissingBean(value={TransactionHandlerRegistry.class})
    public TransactionHandlerRegistry transactionHandlerRegistry(RocketMQTemplate template) {
        return new TransactionHandlerRegistry(template);
    }

    @Bean(name={"org.springframework.rocketmq.spring.starter.internalRocketMQTransAnnotationProcessor"})
    @ConditionalOnBean(value={TransactionHandlerRegistry.class})
    public static RocketMQTransactionAnnotationProcessor transactionAnnotationProcessor(TransactionHandlerRegistry transactionHandlerRegistry) {
        return new RocketMQTransactionAnnotationProcessor(transactionHandlerRegistry);
    }
}

