/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rocketmq.integration;

import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.rocketmq.consuming.RocketMQListenerBindingContainer;
import org.springframework.cloud.stream.binder.rocketmq.metrics.Instrumentation;
import org.springframework.cloud.stream.binder.rocketmq.metrics.InstrumentationManager;
import org.springframework.cloud.stream.binder.rocketmq.properties.RocketMQConsumerProperties;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class RocketMQInboundChannelAdapter
extends MessageProducerSupport {
    private static final Logger log = LoggerFactory.getLogger(RocketMQInboundChannelAdapter.class);
    private RetryTemplate retryTemplate;
    private RecoveryCallback<? extends Object> recoveryCallback;
    private RocketMQListenerBindingContainer rocketMQListenerContainer;
    private final ExtendedConsumerProperties<RocketMQConsumerProperties> consumerProperties;
    private final InstrumentationManager instrumentationManager;

    public RocketMQInboundChannelAdapter(RocketMQListenerBindingContainer rocketMQListenerContainer, ExtendedConsumerProperties<RocketMQConsumerProperties> consumerProperties, InstrumentationManager instrumentationManager) {
        this.rocketMQListenerContainer = rocketMQListenerContainer;
        this.consumerProperties = consumerProperties;
        this.instrumentationManager = instrumentationManager;
    }

    protected void onInit() {
        if (this.consumerProperties == null || !((RocketMQConsumerProperties)this.consumerProperties.getExtension()).getEnabled().booleanValue()) {
            return;
        }
        super.onInit();
        if (this.retryTemplate != null) {
            Assert.state((this.getErrorChannel() == null ? 1 : 0) != 0, (String)"Cannot have an 'errorChannel' property when a 'RetryTemplate' is provided; use an 'ErrorMessageSendingRecoverer' in the 'recoveryCallback' property to send an error message when retries are exhausted");
        }
        BindingRocketMQListener listener = new BindingRocketMQListener();
        this.rocketMQListenerContainer.setRocketMQListener(listener);
        if (this.retryTemplate != null) {
            this.retryTemplate.registerListener((RetryListener)listener);
        }
        try {
            this.rocketMQListenerContainer.afterPropertiesSet();
        }
        catch (Exception e) {
            log.error("rocketMQListenerContainer init error: " + e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("rocketMQListenerContainer init error: " + e.getMessage(), e);
        }
        this.instrumentationManager.addHealthInstrumentation(new Instrumentation(this.rocketMQListenerContainer.getTopic() + this.rocketMQListenerContainer.getConsumerGroup()));
    }

    protected void doStart() {
        if (this.consumerProperties == null || !((RocketMQConsumerProperties)this.consumerProperties.getExtension()).getEnabled().booleanValue()) {
            return;
        }
        try {
            this.rocketMQListenerContainer.start();
            this.instrumentationManager.getHealthInstrumentation(this.rocketMQListenerContainer.getTopic() + this.rocketMQListenerContainer.getConsumerGroup()).markStartedSuccessfully();
        }
        catch (Exception e) {
            this.instrumentationManager.getHealthInstrumentation(this.rocketMQListenerContainer.getTopic() + this.rocketMQListenerContainer.getConsumerGroup()).markStartFailed(e);
            log.error("RocketMQTemplate startup failed, Caused by " + e.getMessage());
            throw new MessagingException(MessageBuilder.withPayload((Object)("RocketMQTemplate startup failed, Caused by " + e.getMessage())).build(), (Throwable)e);
        }
    }

    protected void doStop() {
        this.rocketMQListenerContainer.stop();
    }

    public void setRetryTemplate(RetryTemplate retryTemplate) {
        this.retryTemplate = retryTemplate;
    }

    public void setRecoveryCallback(RecoveryCallback<? extends Object> recoveryCallback) {
        this.recoveryCallback = recoveryCallback;
    }

    protected class BindingRocketMQListener
    implements RocketMQListener<Message>,
    RetryListener {
        protected BindingRocketMQListener() {
        }

        public void onMessage(Message message) {
            boolean enableRetry;
            boolean bl = enableRetry = RocketMQInboundChannelAdapter.this.retryTemplate != null;
            if (enableRetry) {
                RocketMQInboundChannelAdapter.this.retryTemplate.execute(context -> {
                    RocketMQInboundChannelAdapter.this.sendMessage(message);
                    return null;
                }, RocketMQInboundChannelAdapter.this.recoveryCallback);
            } else {
                RocketMQInboundChannelAdapter.this.sendMessage(message);
            }
        }

        public <T, E extends Throwable> boolean open(RetryContext context, RetryCallback<T, E> callback) {
            return true;
        }

        public <T, E extends Throwable> void close(RetryContext context, RetryCallback<T, E> callback, Throwable throwable) {
        }

        public <T, E extends Throwable> void onError(RetryContext context, RetryCallback<T, E> callback, Throwable throwable) {
        }
    }
}

